package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.UpdateCabinetBoxReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetReq;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@Slf4j
@RequestMapping("/CabinetBox")
@Api(tags = "[基础信息]箱门信息模块")
public class CabinetBoxController {
    @Resource
    private CabinetBoxService cabinetBoxService;
    //添加箱门信息
    @PostMapping(path="/AddBoxInfo",name="添加箱门信息#logType=30")
    @ApiOperation("添加箱门信息")
    public ApiRes<String> AddOrUpdateBoxInfo(@RequestBody  UpdateCabinetReq req){
        return ApiRes.success(cabinetBoxService.AddOrUpdateBoxInfo(req));
    }

    //添加箱门信息
    @PostMapping(path="/DeleteBox",name="添加箱门信息#logType=30")
    @ApiOperation("删除箱门")
    public ApiRes<String> DeleteBox(@RequestBody @Validated(ValidationApi.delete.class) UpdateCabinetReq req){
        return ApiRes.success(cabinetBoxService.DeleteBox(req));
    }
}
