package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.BusFormDto;
import com.junmp.jyzb.api.bean.query.QueryBusFormReq;
import com.junmp.jyzb.api.bean.req.UpdateBusFormReq;
import com.junmp.jyzb.entity.BusForm;
import com.junmp.jyzb.service.BusFormService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import liquibase.pro.packaged.A;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 业务单据管理模块（只针对业务单据，不包含任何出入库单据）
 */
@RestController
@Slf4j
@RequestMapping("/BussinessManage")
@Api(tags = "[业务]业务管理模块")
public class BussinessController {
    @Resource
    public BusFormService busFormService;


    //创建或者修改业务单
    @PostMapping(path="/AddBussinessOrder",name="创建或者修改业务单#logType=30")
    @ApiOperation("创建或者修改业务单")
    public ApiRes<String> AddBussinessOrder(@RequestBody  UpdateBusFormReq req){

        return ApiRes.success(busFormService.AddBussinessOrder(req));
    }


    //查看业务单（可以条件查询）

    @PostMapping(path="/showBussinessOrder",name="查看业务单#enable")
    @ApiOperation("查看业务单")
    public ApiRes<PageResult<BusForm>> showBussinessOrder(@RequestBody QueryBusFormReq req){
        return ApiRes.success(busFormService.showBussinessOrder(req));
    }
    //根据业务单id查询出入库单据
    @PostMapping(path="/showOrderByBusOrderId",name="根据业务单id查询出入库单据#enable")
    @ApiOperation("根据业务单id查询出入库单据")
    public ApiRes<Object> showOrderByBusOrderId(@RequestBody QueryBusFormReq req){
        return ApiRes.success(busFormService.showOrderByBusOrderId(req));
    }


    //删除待提交的业务单据
    @PostMapping(path = "/delToSubmitOrder",name="删除待提交的业务单据#logType=30")
    @ApiOperation("删除待提交的业务单据")
    public ApiRes<Boolean> delToSubmitOrder(@RequestBody @Validated(ValidationApi.delete.class) UpdateBusFormReq req){
        return ApiRes.success(busFormService.delToSubmitOrder(req));
    }


}
