package com.junmp.jyzb.config.rabbitMQ;

import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

@Configuration
public class DirectRabbitConfig {
    @Resource
    private ConnectionFactory connectionFactory;

    @Bean
    public RabbitAdmin rabbitAdmin() {
        return new RabbitAdmin(connectionFactory);
    }
    // 死信交换机名称
    private static final String DEAD_EXCHANGE = "dead_exchange";
    //队列 起名：
    @Bean
    public Queue TestQueue() {
        return new Queue("TestQueue",true);
    }

    //Direct交换机 起名
    @Bean
    public DirectExchange TestExchange()    {
        return new DirectExchange("TestExchange",true,false);
    }

    //绑定  将队列和交换机绑定, 并设置用于匹配键：Test1Routing
    @Bean
    Binding bindingDirect() {
        return BindingBuilder.bind(TestQueue()).to(TestExchange()).with("Test1Routing");
    }

    //给交换机取名为OrderExchange（任务单模块交换机）
    @Bean
    public DirectExchange OrderExchange(){
        return new DirectExchange("OrderExchange",true,false);
    }
    //给队列取名字为OrderQueue（任务单模块队列）
    @Bean
    public Queue OrderQueue(){
        return new Queue("OrderQueue",true);
    }
    //将队列和交换机进行绑定
    @Bean
    Binding bindQueueExchange(){
        return BindingBuilder.bind(OrderQueue()).to(OrderExchange()).with("OrderRouting");
    }
}