package com.junmp.jyzb.cache;

import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.cache.AbstractRedisCache;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Component
public class OutInRecordRedisCache extends AbstractRedisCache<Object> {
    public OutInRecordRedisCache(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
    }

    @Override
    public String getCommonKeyPrefix() {
        return JYZBConstant.JYZB_TEMP_PREFIX;
    }

    public void addRecord(String orderMainId, LogSummaryReq req, Long timestamp) {

        getRedisTemplate().opsForZSet().add("orderMainId:"+orderMainId, req, timestamp);
        put(orderMainId, req);
    }
    public List<Object> getDataByTimestampRange(String orderMainId) {

//        Set<Object> dataInRange =getRedisTemplate().opsForZSet().rangeByScore("orderMainId:"+orderMainId, startTimestamp, endTimestamp);
        Set<Object> range = getRedisTemplate().opsForZSet().range("orderMainId:" + orderMainId, 0, -1);

        return new ArrayList<>(range);
    }
}
