package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum UserExceptionEnum implements IExceptionEnum {
    /**
     * 账号已存在
     */
    USER_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"账号已存在"),
    /**
     * 账号已存在
     */
    POLICE_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"警员已存在")
    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    UserExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
