package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum PolicemanFingerExceptionEnum implements IExceptionEnum {
    /**
     * 警员指纹已存在
     */
    POLICEMAN_FINGER_EXCEPTION_ENUM(CommonConstant.DEFAULT_USER_ERROR_CODE,"警员指纹信息已存在"),

    /**
     * 警员指纹不存在
     */
    POLICEMAN_FINGER_NOTEXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE,"警员指纹不存在"),
    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    PolicemanFingerExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
