package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;


@Getter
public enum ManufacturerExceptionEnum implements IExceptionEnum {
    MANUTACTURER_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"生产厂商已经存在"),
    MANUFACTURER_NOT_CHOOSE(CommonConstant.DEFAULT_USER_ERROR_CODE,"删除时未选中需要删除的生产厂商"),
    MANUFACTURER_ISNOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"生产厂商为空或者不存在")
    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;


    ManufacturerExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
