package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 13:08
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Getter
public enum CompanyExceptionEnum implements IExceptionEnum {

    /**
     * 应用不存在
     */
    COMPANY_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 12, "企业不存在"),;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    CompanyExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
