package com.junmp.jyzb.api.bean.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentFontStyle;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.BorderStyleEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

import static com.alibaba.excel.enums.poi.HorizontalAlignmentEnum.CENTER;

@Data
public class TjOrgPoliceExportVo {

    @ExcelProperty("装备名称")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String typeName;

    @ExcelProperty("号型")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String sizeName;

    @ExcelProperty("装备总数")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer num;

    @ExcelProperty("在库数")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer inNum;

    @ExcelProperty("出库数")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer outNum;
}
