package com.junmp.jyzb.api.bean.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentFontStyle;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.BorderStyleEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

import static com.alibaba.excel.enums.poi.HorizontalAlignmentEnum.CENTER;

@Data
public class TjOrgCountExportVo {
    /**
     * 类型名称
     */
    @ExcelProperty("类型名称")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String typeName;


    /**
     * 号型名称
     */
    @ExcelProperty("号型名称")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String sizeName;

    /**
     * 装备总数
     */
    @ExcelProperty("装备总数")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer number;

    /**
     * 使用次数
     */
    @ExcelProperty("使用次数")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer useCount;

    /**
     * 维修次数
     */
    @ExcelProperty("维修次数")
    @ColumnWidth(10)
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer fixCount;




}
