package com.junmp.jyzb.api.bean.vo;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.*;
import com.alibaba.excel.enums.BooleanEnum;
import com.alibaba.excel.enums.poi.BorderStyleEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

import static com.alibaba.excel.enums.poi.HorizontalAlignmentEnum.CENTER;

@Data
@Builder
@HeadRowHeight(value = 15)
@HeadStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER)
@HeadFontStyle(fontName = "宋体",fontHeightInPoints = 12,bold = BooleanEnum.TRUE)
public class InventoryVo {

    /**
     * 装备包ID
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "装备包ID")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String packageId;

    /**
     * 装备类型ID
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "装备类型ID")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String typeId;

    /**
     * 装备类型名称
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "装备类型名称")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String typeName;
    /**
     * 装备型号ID
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "装备型号ID")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String sizeId;
    /**
     * 装备型号名称
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "装备型号名称")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String sizeName;
    /**
     * 供应商ID
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "供应商ID")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String supplierId;
    /**
     * 供应商名称
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "供应商名称")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String supplierName;

    /**
     * 货架位置
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "货架位置")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String shelfLocation;

    /**
     * 货架id
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "货架id")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String shelfId;


    /**
     * epc
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "epc")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String epc;

    /**
     * 组织机构ID
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "组织机构ID")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Long orgId;

    /**
     * 规格尺寸
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "规格尺寸")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String state;

    /**
     * 业务状态
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "业务状态")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String bussinessState;

    /**
     * 位置状态
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "位置状态")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String locationState;


    /**
     * 生产日期
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "生产日期")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Date productionDate;

    /**
     * 质保期
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "质保期")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private long warrantyPeriod;

    /**
     * 维保期
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "维保期")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer maintenancePeriod;

    /**
     * 维修次数
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "维修次数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer fixCount;
    /**
     * 超期状态
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "超期状态")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private int termState;
    /**
     * 位置类型
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "位置类型")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer locationType;

    /**
     * 位置ID
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "位置ID")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String locationId ;

    /**
     * 是否遗失
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "是否遗失")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer lostFlag ;


    /**
     * 标签id
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "标签id")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String tid ;

    /**
     * 价格
     */
    @ColumnWidth(10)
    @ExcelProperty(value = "价格")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private BigDecimal price ;


}
