package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
@Data
public class UpdateQuickSuggestionsReq {

    /**
     * id
     */
    @NotNull(message = "删除时主键id不能为空",groups = {ValidationApi.delete.class})
    private Long id;

    /**
     * 用户id
     */
    @NotNull(message = "用户id不能为空",groups = {ValidationApi.add.class})
    private Long userId;

    /**
     * 审批意见
     */
    @NotBlank(message = "审批意见不能为空",groups = {ValidationApi.add.class})
    private String text;

    /**
     * 应用场景（1为审批时使用）
     */
    @NotNull(message = "应用场景不能为空",groups = {ValidationApi.add.class})
    private Integer useType;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;
}
