package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class UpdateOrgReq {

    /**
     * 状态
     */
    @NotNull(message = "状态不能为空", groups = {ValidationApi.edit.class})
    private Integer statusFlag;
    /**
     * 组织机构列表
     */
    @NotNull(message = "组织机构不能为空", groups = {ValidationApi.updateStatus.class})
    private List<String> orgIdList;

    @NotNull(message = "上级组织机构不能为空",groups = {ValidationApi.add.class})
    private Long orgParentId;
    private String orgParentIds;
    @NotBlank(message = "组织机构名称不能为空",groups = {ValidationApi.add.class,ValidationApi.edit.class})
    private String orgName;
    @NotBlank(message = "组织机构编码不能为空",groups = {ValidationApi.add.class})
    private String orgCode;
    private Integer isDepartment;
    private String areaName;
    private Integer levelFlag;
    private String dName;
    @NotNull(message = "状态不能为空",groups = {ValidationApi.updateStatus.class})
    private Integer delFlag;
    private String findCode;
    @NotNull(message = "组织机构id不能为空",groups = {ValidationApi.edit.class, ValidationApi.detail.class})
    private Long orgId;


}


