package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class CabinetPolicemanReq extends BaseRequest {

    @NotBlank(message = "警员主键不能为空", groups = {edit.class, delete.class, detail.class})
    private String policeId;

    @NotBlank(message = "警员名字不能为空", groups = {add.class,edit.class})
    private String name;

    private String cabinetOrgId;

    private String currentCabinetId;
    @NotNull(message = "组织机构id不能为空", groups = {add.class,edit.class})
    private Long orgId;

    @NotBlank(message = "警员编号不能为空", groups = {add.class,edit.class})
    private String policeCode;

    @NotBlank(message = "人脸信息不能为空", groups = {detail.class})
    private String photo;

    @NotBlank(message = "主柜不能为空", groups = {add.class,edit.class})
    private String serialNum;
    /**
     * 指纹list
     */
    private String finger;

    private String password;

    private  List<Long> RolesList;

}