package com.junmp.jyzb.api.bean.dto;

import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Data
public class OrgTreeDto implements Serializable {
    private Long orgId;
    private String name;
    private String code;
    private Integer type;
    private Long orgParentId;
    private String areaName;
    private String levelFlag;
    private String dName;
    private transient List<OrgTreeDto> child = new ArrayList<>();

    public void addChild(OrgTreeDto child) {
        this.child.add(child);
    }
    public OrgTreeDto copyIngnoreChildren() {
        OrgTreeDto desBean = new OrgTreeDto();
        BeanUtils.copyProperties(this, desBean, "children", "info");
        return desBean;
    }
}



