package com.junmp.jyzb.api.bean.dto;

import lombok.Data;

import java.util.Date;

@Data
public class OrderLogDto {
    /**
     * 主键
     */
    private String id;

    /**
     * 单据类型（in入库单，out出库单）
     */
    private String orderType;

    /**
     * 单据业务类型
     */
    private String bussinessType;

    /**
     * 单据id（对应order_main）
     */
    private String orderId;

    /**
     * 操作记录（upload上传消息）
     */
    private String historyMsg;

    /**
     * 组织机构id
     */
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;

    /**
     * 单据单号
     */
    private String orderCode;

    /**
     * 应入/出库数量
     */
    private Integer inventoryQuantity;

    /**
     * 实际数量
     */
    private Integer actualQuantity;

    /**
     * 修改后数量
     */
    private Integer updateQuantity;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 修改人员
     */
    private String updateUser;

    /**
     * 过程事件（创建单据createOrder,出入库OutAndIn，记账accounting）
     */
    private String processType;
}
