package com.junmp.jyzb.api.bean.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class LogDetailDto implements Serializable {
    /**
     * 出入库明细ID
     */
    private Long id;

    /**
     * 物资id
     */
    private String inventoryId;

    private String bussinessType;

    /**
     * 出入库汇总ID
     */
    private Long summaryId;

    /**
     * 单据ID
     */
    private String orderMainId;

    /**
     * EPC信息
     */
    private String epc;

    /**
     * 装备名称
     */
    private String typeName;

    /**
     * 装备号型
     */
    private String sizeName;

    /**
     * 供应商
     */
    private String supplierName;

    /**
     * 装备类型:0单件/1装备包
     */
    private Integer equipmentType;

    /**
     * 状态，0正常/1异常
     */
    private Integer errorState;


    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 照片信息
     */
    private String picture;

    /**
     * 作业设备：0手持机 1单警柜 2通道,3仓库，4人工记账）
     */
    private String deviceType;

    /**
     * 存储ID
     */
    private String locationId;

    /**
     * 存储名称：XX仓库，XX单警柜
     */
    private String locationName;

    private BigDecimal price;

    private String outInState;
    //经办人（操作人）
    private String userName;
    //装备总数
    private Integer number;

}
