package com.junmp.jyzb.api.bean.Validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class IsNumberValidator implements ConstraintValidator<IsNumber, String> {


    @Override
    public void initialize(IsNumber constraintAnnotation) {
    }
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true; // 允许字段为空
        }

        try {
            Double.parseDouble(value);
            return true; // 字段是数字
        } catch (NumberFormatException e) {
            return false; // 字段不是数字
        }
    }

}
