package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.DestoryUnitReq;
import com.junmp.jyzb.api.bean.req.RepairUnitReq;
import com.junmp.jyzb.api.exception.enums.DestoryUnitExceptionEnum;
import com.junmp.jyzb.api.exception.enums.RepairUnitExceptionEnum;
import com.junmp.jyzb.entity.DestoryUnit;
import com.junmp.jyzb.entity.RepairUnit;
import com.junmp.jyzb.service.RepairUnitService;
import com.junmp.jyzb.mapper.RepairUnitMapper;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
* @author lxh专属坐骑
* @description 针对表【base_repair_unit(维修单位表)】的数据库操作Service实现
* @createDate 2023-10-16 09:35:11
*/
@Service
public class RepairUnitServiceImpl extends ServiceImpl<RepairUnitMapper, RepairUnit>
    implements RepairUnitService{

    @Override
    public String addRepairUnit(RepairUnitReq req) {
        //判断是否已经存在短码，如果存在则不再允许添加成功
        RepairUnit one = getOne(new LambdaQueryWrapper<RepairUnit>().eq(RepairUnit::getCode, req.getName()));
        if (ObjectUtil.isNotNull(one)){
            throw new ServiceException(RepairUnitExceptionEnum.REPAIRUNIT_IS_EXIST);
        }
        RepairUnit repairUnit = new RepairUnit();
        BeanPlusUtil.copyProperties(req,repairUnit);
        repairUnit.setCreateTime(DateTimeUtil.getCurrentDateTime());
        save(repairUnit);
        return repairUnit.getId();
    }

    @Override
    public boolean updateRepairUnit(RepairUnitReq req) {
        RepairUnit repairUnit = new RepairUnit();
        BeanPlusUtil.copyProperties(req,repairUnit);
        repairUnit.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return updateById(repairUnit);
    }

    @Override
    public List<RepairUnit> showRepairUnitList(RepairUnitReq req) {
        LambdaQueryWrapper<RepairUnit> wrapper = createWrapper(req);
        return  list(wrapper);
    }

    @Override
    public PageResult<RepairUnit> showRepairUnitPage(RepairUnitReq req) {
        LambdaQueryWrapper<RepairUnit> wrapper = createWrapper(req);
        Page<RepairUnit> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), wrapper);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean delRepairUnit(RepairUnitReq req) {
        //抛出异常，销毁、报废单位未选中
        if (req.getDeleteList().size()==0){
            throw new ServiceException(RepairUnitExceptionEnum.REPAIRUNIT_NOT_CHOOSE);
        }
        //查询出全部的销毁、报废单位
        Set<String> collect = list().stream().map(RepairUnit::getId).collect(Collectors.toSet());
        Set<String> delList=new HashSet<>(req.getDeleteList());
        if (collect.containsAll(delList)){
            return removeBatchByIds(req.getDeleteList());
        }else {
            throw new ServiceException(RepairUnitExceptionEnum.REPAIRUNIT_NOT_EXIST);
        }
    }

    private LambdaQueryWrapper<RepairUnit> createWrapper(RepairUnitReq req){
        LambdaQueryWrapper<RepairUnit> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)){
            return wrapper;
        }
        wrapper.eq(ObjectUtil.isNotNull(req.getId()),RepairUnit::getId,req.getId());
        wrapper.eq(ObjectUtil.isNotNull(req.getState()),RepairUnit::getState,req.getState());
        wrapper.like(ObjectUtil.isNotNull(req.getName()),RepairUnit::getName,req.getName());
        wrapper.like(ObjectUtil.isNotNull(req.getShortName()),RepairUnit::getShortName,req.getShortName());
        wrapper.like(ObjectUtil.isNotNull(req.getContacts()),RepairUnit::getContacts,req.getContacts());
        wrapper.orderByDesc(RepairUnit::getCreateTime);
        return wrapper;
    }
}




