package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class QueryOrderLogReq extends BaseRequest {
    /**
     * 主键
     */
    private String id;

    /**
     * 单据类型（in入库单，out出库单）
     */
    private String orderType;

    /**
     * 单据业务类型
     */
    private String bussinessType;

    /**
     * 单据id（对应order_main）
     */
    private String orderId;

    /**
     * 操作记录（upload上传消息）
     */
    private String historyMsg;

    /**
     * 组织机构id
     */
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;

    /**
     * 单据单号
     */
    private String orderCode;

    /**
     * 应入/出库数量
     */
    private Integer inventoryQuantity;

    /**
     * 实际数量
     */
    private Integer actualQuantity;

    /**
     * 修改后数量
     */
    private Integer updateQuantity;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 修改人员
     */
    private String updateUser;

    private Date startTime;
    private Date endTime;
}
