package com.junmp.jyzb.utils;

import com.alibaba.fastjson.JSON;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
@Service
public class RabbitMQSendMsg {
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private RabbitAdmin rabbitAdmin;
    public  void SendMsg(String exchangeName,String name,Object msg)
    {
        //exchangeName交换机名称，name组织机构名称，msg发送的消息
        Queue queue=new Queue(name,true,false,false);
        Exchange exchange = new DirectExchange(exchangeName, true, false);
        rabbitAdmin.declareQueue(queue);
        rabbitAdmin.declareExchange(exchange);
        rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(name).noargs());
        String jsonString = JSON.toJSONString(msg);
        rabbitTemplate.convertAndSend(exchangeName, name, jsonString);
    }
}
