package com.junmp.jyzb.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class DateTimeUtil {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date getCurrentDateTime() {
        Date currentDate = new Date();
        String dateString = DATE_FORMAT.format(currentDate);
        try {
            return DATE_FORMAT.parse(dateString);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Map<String,Object>> timeSort(List<Map<String,Object>> allPoliceman) {
        Collections.sort(allPoliceman, new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Date updateTime1 = (Date) o1.get("updateTime");
                Date updateTime2 = (Date) o2.get("updateTime");
                return updateTime2.compareTo(updateTime1);
            }
        });
        return allPoliceman;
    }

}