package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.EqsSumDto;
import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.OrgDto;
import com.junmp.jyzb.api.bean.dto.TjDto.*;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjCountReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgEqsReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgPriceReq;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.service.TjService;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class TjServiceImpl implements TjService {
    @Resource
    private PubOrgMapper pubOrgMapper;

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private InventorySummaryMapper inventorySummaryMapper;

    @Resource
    private EquipmentSizeService equipmentSizeService;

    @Resource
    private PriceSumSummaryMapper priceSumSummaryMapper;

    @Resource
    private EquipmentCountSummaryMapper equipmentCountSummaryMapper;


    //装备统计报表
    @Override
    public List<TjOrgEqsDto> showOrgEqsList(InventoryReq req) {
        //我先查询出他组织机构id中的数据，然后放在list的第一个，然后将他的下一层全部查询出来以后，根据组织机构编号进行比较，最终输出一个有序的list返回
        List<TjOrgEqsDto> list= inventorySummaryMapper.getByOrgId(req.getOrgId());
        List<Long> collect1 = list.stream().map(tjOrgEqsDto -> {
            Long orgId=tjOrgEqsDto.getOrgId();
            return orgId;
        }).collect(Collectors.toList());
        //将组织机构下库存信息信息查询出来
        List<EqsSumDto> childrenList=inventorySummaryMapper.getEqsByOrgId(collect1,req.getTypeId(),req.getSizeId());

        Map<Long, List<EqsSumDto>> eqsSumDtoMap = new HashMap<>();
        for (EqsSumDto eqsSumDto : childrenList) {
            Long orgId = eqsSumDto.getOrgId();
            if (eqsSumDtoMap.containsKey(orgId)) {
                List<EqsSumDto> eqsSumDtoList = eqsSumDtoMap.get(orgId);
                eqsSumDtoList.add(eqsSumDto);
            } else {
                List<EqsSumDto> eqsSumDtoList = new ArrayList<>();
                eqsSumDtoList.add(eqsSumDto);
                eqsSumDtoMap.put(orgId, eqsSumDtoList);
            }
        }

        for (TjOrgEqsDto tjOrgEqsDto : list) {
            Long orgId = tjOrgEqsDto.getOrgId();
            if (eqsSumDtoMap.containsKey(orgId)) {
                List<EqsSumDto> eqsSumDtoList = eqsSumDtoMap.get(orgId);
            }
        }
        //对查询的组织机构进行有序排列
        List<TjOrgEqsDto> collect = list.stream()
                .sorted((o1, o2) -> {
                    String orgCode1 = o1.getOrgCode();
                    String orgCode2 = o2.getOrgCode();

                    // Check if either orgCode contains letters
                    boolean hasLetter1 = orgCode1.matches(".*[a-zA-Z].*");
                    boolean hasLetter2 = orgCode2.matches(".*[a-zA-Z].*");

                    if (hasLetter1 && hasLetter2) {
                        return orgCode1.compareTo(orgCode2); // Alphabetical order
                    } else if (hasLetter1) {
                        return 1; // o2 with letters should come first
                    } else if (hasLetter2) {
                        return -1; // o1 with letters should come first
                    } else {
                        return orgCode1.compareTo(orgCode2); // Numeric order
                    }
                })
                .collect(Collectors.toList());

        return collect;
    }

    @Override
    public FinalTjOrgEqsDto test(TjOrgEqsReq req) {
        List<String> typeIdsList = req.getTypeIdsList();
        List<String> sizeNameList = req.getSizeNameList();
//        int size = typeIdsList.size();
//        int size1 = sizeNameList.size();
        boolean notNull = ObjectUtil.isNotNull(req.getTypeIdsList());
        boolean s = ObjectUtil.isNotNull(req.getSizeNameList());
//        System.out.println("yiyi = " + req.getTypeIdsList().isEmpty());
        System.out.println("yiyi = " + ObjectUtil.isEmpty(req.getTypeIdsList()));
//        System.out.println("yiyi = " + req.getTypeIdsList().isEmpty());
        return null;
    }

//    @Override
//    public List<TjOrgEqsDto> test(InventoryReq req) {
//        List<TjOrgEqsDto> tJOrgEqsDtoList = inventorySummaryMapper.test(req);
//        List<TjOrgEqsDto> dynamicViewList = inventorySummaryMapper.selectDynamicView();
//        return dynamicViewList;
//    }

    @Override
    public PageResult<TjOrgEqsDto> TjOrgEqs(TjOrgEqsReq req) {
        //我得先将typeid传递的最下层的装备idlist拿到
//        List<String> typeIdsList = equipmentSizeService.selectByTypeIds(req.getTypeIdsList());
//        List<String> sizeNameList = req.getSizeNameList();
        //将前端传递的值进行处理并且执行存储过程
        String sql="and (org_id="+req.getOrgId()+" or org_parent_id = "+req.getOrgId()+")";
        if (!ObjectUtil.isEmpty(req.getTypeIdsList()) && req.getTypeIdsList().size()>0){
            sql+="and type_id in (";
            for (String typeId:req.getTypeIdsList()) {
                sql+=typeId+",";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql+=")";
        }
        if (!ObjectUtil.isEmpty(req.getSizeNameList()) && req.getSizeNameList().size()>0){
            sql+="and size_name in (";
            for (String sizeName:req.getSizeNameList()) {
                sql+="'"+sizeName+"',";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql+=")";
        }
        System.out.println("sql = " + sql);
        //执行存储过程
        inventorySummaryMapper.useViewOrgeqs(sql);
        //查询视图
        List<TjOrgEqsDto> tjOrgEqsDtoList = inventorySummaryMapper.selectViewOrgeqsSum();
        //查询出来的组织机构进行判断，如果该组织机构下的装备装备总数为0，那么将该组织机构从list中移除
        tjOrgEqsDtoList.removeIf(tjOrgEqsDto -> tjOrgEqsDto.getTotalNumber() == 0);
        //将组织机构进行排序后再进行返回
        Comparator<TjOrgEqsDto> orgComparator = createOrgComparator();
        Collections.sort(tjOrgEqsDtoList, orgComparator);

        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        Page<TjOrgEqsDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        long startIndex = (req.getPageNo() - 1) * req.getPageSize();
        long endIndex = Math.min(startIndex + req.getPageSize(), tjOrgEqsDtoList.size());
        List<TjOrgEqsDto> subList = tjOrgEqsDtoList.subList((int)startIndex, (int)endIndex);
//        List<TjOrgEqsDto> subList = tjOrgEqsDtoList.subList((int) ((req.getPageNo()-1)*req.getPageSize()), req.getPageSize().intValue());
        page.setRecords(subList);
        page.setTotal(tjOrgEqsDtoList.size());
//        finalTjOrgEqsDto.setTjOrgEqsDto(tjOrgEqsDtoList);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public FinalTjOrgEqsDto TjOrgEqsSum(TjOrgEqsReq req) {
        //将前端传递的值进行处理并且执行存储过程
        String sql="and (org_id="+req.getOrgId()+" or org_parent_id = "+req.getOrgId()+")";
        if (!ObjectUtil.isEmpty(req.getTypeIdsList()) && req.getTypeIdsList().size()>0){
            sql+="and type_id in (";
            for (String typeId:req.getTypeIdsList()) {
                sql+=typeId+",";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql+=")";
        }
        if (!ObjectUtil.isEmpty(req.getSizeNameList()) && req.getSizeNameList().size()>0){
            sql+="and size_name in (";
            for (String sizeName:req.getSizeNameList()) {
                sql+="'"+sizeName+"',";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql+=")";
        }
        System.out.println("sql = " + sql);
        //执行存储过程
        inventorySummaryMapper.useViewOrgeqs(sql);
        //在内存foreach还是去数据库再去查询一次
        FinalTjOrgEqsDto finalTjOrgEqsDto=inventorySummaryMapper.getSumByViewOrgeqsSum();
        if (ObjectUtil.isNotNull(finalTjOrgEqsDto)) {
            return finalTjOrgEqsDto;
        }else {
            return new FinalTjOrgEqsDto();
        }

    }



    //查看装备统计详情
    @Override
    public PageResult<InventorySumDto> TjOrgEqsDetailPage(TjOrgEqsReq req) {
        int size = inventorySummaryMapper.TjOrgEqsDetailSum(req.getOrgId(), req.getTypeIdsList(), req.getSizeNameList());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        Page<InventorySumDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        List<InventorySumDto> returnList=inventorySummaryMapper.TjOrgEqsDetail(req.getOrgId(),req.getTypeIdsList(),
                req.getSizeNameList(),(req.getPageNo()-1)* req.getPageSize(),req.getPageSize());
        page.setTotal(size);
        page.setRecords(returnList);
        return PageResultFactory.createPageResult(page);
    }

    //查看装备统计详情
    @Override
    public List<InventorySumDto> TjOrgEqsDetailList(TjOrgEqsReq req) {
        List<InventorySumDto> returnList=inventorySummaryMapper.TjOrgEqsDetail(req.getOrgId(),req.getTypeIdsList(),
                req.getSizeNameList(),null,null);
        return returnList;
    }

    //财务统计报表
    @Override
    public PageResult<TjOrgPriceDto> TjOrgPrice(TjOrgPriceReq req) {
        //根据条件查询财务汇总表
        List<TjOrgPriceDto> tjOrgPriceDtoList=priceSumSummaryMapper.TjOrgPrice(req.getOrgId(), req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList());
        //对组织机构进行排序
        Comparator<TjOrgPriceDto> orgComparator = createOrgComparator();
        Collections.sort(tjOrgPriceDtoList, orgComparator);
        Page<TjOrgPriceDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        long startIndex = (req.getPageNo() - 1) * req.getPageSize();
        long endIndex = Math.min(startIndex + req.getPageSize(), tjOrgPriceDtoList.size());
        List<TjOrgPriceDto> subList = tjOrgPriceDtoList.subList((int) startIndex, (int)endIndex);
//        List<TjOrgPriceDto> subList = tjOrgPriceDtoList.subList((int) ((req.getPageNo()-1)*req.getPageSize()), req.getPageSize().intValue());
        page.setTotal(tjOrgPriceDtoList.size());
        page.setRecords(subList);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public FinalTjOrgPriceDto TjOrgPriceSum(TjOrgPriceReq req) {

        FinalTjOrgPriceDto finalTjOrgPriceDto= priceSumSummaryMapper.TjOrgPriceSum(req.getOrgId(), req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList());
        if (ObjectUtil.isNotNull(finalTjOrgPriceDto)) {

            return finalTjOrgPriceDto;
        }else {
            return new FinalTjOrgPriceDto();
        }

    }


    //查看财务统计详情
    @Override
    public PageResult<TjOrgPriceDto> TjOrgPriceDetailPage(TjOrgPriceReq req) {
        int size = priceSumSummaryMapper.TjOrgPriceDetailSum(req.getOrgId(),req.getYear(),req.getTypeIdsList(),req.getSizeNameList());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        Page<TjOrgPriceDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        List<TjOrgPriceDto> returnList=priceSumSummaryMapper.TjOrgPriceDetail(req.getOrgId(),req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),(req.getPageNo()-1)* req.getPageSize(),req.getPageSize());
        page.setTotal(size);
        page.setRecords(returnList);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public List<TjOrgPriceDto> TjOrgPriceDetailList(TjOrgPriceReq req) {
        List<TjOrgPriceDto> returnList=priceSumSummaryMapper.TjOrgPriceDetail(req.getOrgId(),req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),null,null);
        return returnList;
    }


    public <T> Comparator<T> createOrgComparator() {
        return (org1,org2) ->{

            try {
                String orgCode1 = (String) org1.getClass().getMethod("getOrgCode").invoke(org1);
                String orgCode2 = (String) org2.getClass().getMethod("getOrgCode").invoke(org2);

                // 判断是否包含字母
                boolean hasLetter1 = orgCode1.matches(".*[a-zA-Z]+.*");
                boolean hasLetter2 = orgCode2.matches(".*[a-zA-Z]+.*");

                // 如果其中一个包含字母，则将其放到排序的最后
                if (hasLetter1 && !hasLetter2) {
                    return 1; // orgCode1包含字母，orgCode2不包含字母，orgCode1排在orgCode2后面
                } else if (!hasLetter1 && hasLetter2) {
                    return -1; // orgCode1不包含字母，orgCode2包含字母，orgCode1排在orgCode2前面
                }

                // 如果两个orgCode都不含有字母，则按照每两位进行排序
                String[] orgCodeArray1 = orgCode1.split("(?<=\\G..)");
                String[] orgCodeArray2 = orgCode2.split("(?<=\\G..)");

                // 从最后一组（即最后两位）开始比较数字大小
                int index1 = orgCodeArray1.length - 1;
                int index2 = orgCodeArray2.length - 1;
                while (index1 >= 0 && index2 >= 0) {
                    String codeValue1 = orgCodeArray1[index1];
                    String codeValue2 = orgCodeArray2[index2];

                    // 判断是否可以转换为整数，如果不能，则说明包含字母，直接返回结果
                    try {
                        int intValue1 = Integer.parseInt(codeValue1, 10);
                        int intValue2 = Integer.parseInt(codeValue2, 10);
                        int compareResult = Integer.compare(intValue1, intValue2);
                        if (compareResult != 0) {
                            return compareResult;
                        }
                    } catch (NumberFormatException e) {
                        // orgCode包含字母，直接返回结果
                        return codeValue1.compareTo(codeValue2);
                    }

                    index1--;
                    index2--;
                }

                // 如果orgCode长度不同，那么较长的orgCode排在后面
                return Integer.compare(orgCodeArray1.length, orgCodeArray2.length);
            } catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        };
    }

    @Override
    public PageResult<TjCountDto> TjOrgCount(TjCountReq req) {
        List<TjCountDto> tjCountDtoList=equipmentCountSummaryMapper.TjOrgCount(req.getOrgId(),
                req.getTypeIdsList(),req.getSizeNameList(),req.getYear());
        //对组织机构进行排序
        Comparator<TjCountDto> orgComparator = createOrgComparator();
        Collections.sort(tjCountDtoList, orgComparator);
        Page<TjCountDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        long startIndex = (req.getPageNo() - 1) * req.getPageSize();
        long endIndex = Math.min(startIndex + req.getPageSize(), tjCountDtoList.size());
        List<TjCountDto> subList = tjCountDtoList.subList((int) startIndex, (int)endIndex);
        page.setTotal(tjCountDtoList.size());
        page.setRecords(subList);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public FinalTjCountDto TjOrgCountSum(TjCountReq req) {
        FinalTjCountDto finalTjCountDto=equipmentCountSummaryMapper.TjOrgCountSum(req.getOrgId(),req.getSizeNameList(),
                req.getTypeIdsList(), req.getYear());
        if (ObjectUtil.isNotNull(finalTjCountDto)) {
            return finalTjCountDto;
        }else {
            return new FinalTjCountDto();
        }
    }

    @Override
    public PageResult<TjCountDto> TjOrgCountDetailPage(TjCountReq req) {
        int size = equipmentCountSummaryMapper.TjOrgCountDetailSum(req.getOrgId(),req.getYear(),req.getTypeIdsList(),req.getSizeNameList());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        Page<TjCountDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        List<TjCountDto> returnList=equipmentCountSummaryMapper.TjOrgCountDetail(req.getOrgId(),req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),(req.getPageNo()-1)* req.getPageSize(),req.getPageSize());
        page.setTotal(size);
        page.setRecords(returnList);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public List<TjCountDto> TjOrgCountDetailList(TjCountReq req) {
        List<TjCountDto> returnList=equipmentCountSummaryMapper.TjOrgCountDetail(req.getOrgId(),req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),null,null);
        return returnList;
    }
 }
