package com.junmp.jyzb.mapper;

import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjCountDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjCountDto;
import com.junmp.jyzb.entity.EquipmentCountSummary;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【vie_equipment_count_summary】的数据库操作Mapper
* @createDate 2023-12-14 14:41:35
* @Entity com.junmp.jyzb.entity.EquipmentCountSummary
*/
public interface EquipmentCountSummaryMapper extends BaseMapper<EquipmentCountSummary> {

    void addInfo();

    List<TjCountDto> TjOrgCount(@Param("orgId") Long orgId,
                                @Param("typeIdsList") List<String> typeIdsList,
                                @Param("sizeNameList") List<String> sizeNameList,
                                @Param("year")Integer year);

    FinalTjCountDto TjOrgCountSum(@Param("orgId") Long orgId,
                                  @Param("typeIdsList") List<String> typeIdsList,
                                  @Param("sizeNameList") List<String> sizeNameList,
                                  @Param("year")Integer year);

    int TjOrgCountDetailSum(@Param("orgId")Long orgId,
                            @Param("year") Integer year,
                            @Param("typeIdsList") List<String> typeIdsList,
                            @Param("sizeNameList") List<String> sizeNameList);

    List<TjCountDto> TjOrgCountDetail(@Param("orgId")Long orgId,
                                      @Param("year") Integer year,
                                      @Param("typeIdsList") List<String> typeIdsList,
                                      @Param("sizeNameList") List<String> sizeNameList,
                                      @Param("pageNo")Long pageNo, @Param("pageSize") Long pageSize);
}




