package com.junmp.jyzb.logManager;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.log.api.LogManagerApi;
import com.junmp.v2.log.api.bean.dto.LogRecordDto;
import com.junmp.v2.log.api.bean.req.LogRequest;
import com.junmp.v2.log.db.entity.SysLog;
import com.junmp.v2.log.db.service.SysLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.*;


public class EsLogManager implements LogManagerApi {
    private static final Logger log = LoggerFactory.getLogger(EsLogManager.class);
    @Resource
    private SysLogService sysLogService;

    public EsLogManager() {
    }

    public List<LogRecordDto> findList(LogRequest request) {
        List<SysLog> sysLogList = this.sysLogService.findList(request);
        List<LogRecordDto> dtoList = CollUtil.newArrayList(new LogRecordDto[0]);
        BeanUtil.copyProperties(sysLogList, dtoList, new String[0]);
        return dtoList;
    }

    public PageResult<LogRecordDto> findPage(LogRequest request) {
        return this.sysLogService.getLogPage(request);
    }

    public void del(LogRequest request) {
        this.sysLogService.del(request);
    }

    public void clearLog(LogRequest request) {
        if (ObjectUtil.isNotNull(request) && ObjectUtil.isNotNull(request.getLogType())) {
            this.sysLogService.clearLogByDate(request);
        }

    }

    public LogRecordDto detail(LogRequest request) {
        SysLog detail = this.sysLogService.detail(request);
        LogRecordDto dto = new LogRecordDto();
        BeanUtil.copyProperties(detail, dto, new String[0]);
        return dto;
    }
}
