package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

/**
 * 组织机构信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("pub_org")
@Document(indexName = "org_pinyin")
public class PubOrg implements Serializable {

    //此项作为id，不会写到_source里边。
//    @Id
//    private String id;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO, value = "org_id")
    @Id
    private Long orgId;
    /**
     * 主键
     */
    @TableField(value = "is_department")
    private Integer isDepartment;


    /**
     * 父id，一级节点父id是0
     */
    @TableField(value = "parent_id")
    private String parentId;

    /**
     * 父ids
     */
    @TableField(value = "org_parent_id")
    private Long orgParentId;

    /**
     * 父ids
     */
    @TableField(value = "org_parent_ids")
    private String orgParentIds;

    /**
     * 组织编码
     */
    @TableField(value = "org_code")
    private String orgCode;

    /**
     * 机构类型100企业，101：机构
     */
    @TableField(value = "org_type")
    private Integer orgType;

    /**
     * 排序
     */
    @TableField(value = "sort_val")
    private Integer sortVal;
    /**
     * 状态：1-启用，0-禁用
     */
    @TableField(value = "status_flag")
    private Integer statusFlag;

    /**
     * 描述
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 删除标记：0-已删除，1-未删除
     */
    @TableField(value = "del_flag")
    private Integer delFlag;

    /**
     * 机构全称
     */
    @TableField(value = "org_full_name")
    private String orgFullName;

    /**
     * 经度
     */
    @TableField(value = "longitude")
    private String longitude;

    /**
     * 维度
     */
    @TableField(value = "latitude")
    private String latitude;

    /**
     * 大屏地图使用
     */
    @TableField(value = "is_map")
    private String isMap;

    /**
     * 采购
     */
    @TableField(value = "show_state")
    private String showState;

    /**
     * 单据计数
     */
    @TableField(value = "order_num")
    private Integer orderNum;

    /**
     * levelFlag
     */
    @TableField(value = "level_flag")
    private Integer levelFlag;

    /**
     * 区域码短写
     */
    @TableField(value = "find_code")
    private String findCode;

    /**
     * 地址
     */
    @TableField(value = "address")
    private String address;

    /**
     * 区域名称
     */
    @TableField(value = "area_name")
    private String areaName;

    /**
     * dName
     */
    @TableField(value = "d_name")
    private String dName;

    /**
     * 联系人
     */
    @TableField(value = "contact")
    private String contact;

    /**
     * 电话
     */
    @TableField(value = "phone")
    private String phone;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @TableField(value = "create_user")
    private Long createUser;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 更新人
     */
    @TableField(value = "update_user")
    private Long updateUser;

    /**
     * guid
     */
    @TableField(value = "guid")
    private String guid;

    /**
     * 组织机构名
     */
    @TableField(value = "org_name")
    private String orgName;


}