package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 
 * @TableName base_log_summary
 */
@TableName(value ="base_log_summary")
@Data
public class LogSummary implements Serializable {
    /**
     * 出入库汇总ID
     */
    @TableId(value = "id",type = IdType.AUTO)
    private Long id;

    /**
     * 组织机构ID
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 单据ID
     */
    @TableField(value = "order_main_id")
    private String orderMainId;
    /**
     * 单据编号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 设备标识
     */
    @TableField(value = "device")
    private String device;

    /**
     * 出入设备:0手持机/1单警柜/2通道
     */
    @TableField(value = "device_type")
    private Integer deviceType;

    /**
     * 位置id（存放单警柜id或者是仓库id）
     */
    @TableField(value = "location_id")
    private String locationId;

    /**
     * 位置名称（单警柜，仓库）
     */
    @TableField(value = "location_name")
    private String locationName;

    /**
     * 所属位置（0仓库1单警柜）
     */
    @TableField(value = "location_type")
    private Integer locationType;

    /**
     * 操作时间
     */
    @TableField(value = "use_time")
    private Date useTime;

    /**
     * 业务类型
     */
    @TableField(value = "bussiness_type")
    private String bussinessType;

    /**
     * 操作人员姓名
     */
    @TableField(value = "user_name")
    private String userName;

    /**
     * 照片信息
     */
    @TableField(value = "picture")
    private String picture;

    /**
     * 装备记录集合,警棍/盾牌
     */
    @TableField(value = "equipment_list")
    private String equipmentList;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;


    /**
     * 出入状态
     */
    @TableField(value = "out_in_state")
    private String outInState;

    @TableField(value = "number")
    private Integer number;

    private BigDecimal price;

    private static final long serialVersionUID = 1L;


}