package com.junmp.jyzb.controller;


import com.junmp.jyzb.api.bean.query.QueryTriggerReq;
import com.junmp.jyzb.api.bean.req.UpdateTriggerReq;
import com.junmp.jyzb.entity.Trigger;
import com.junmp.jyzb.service.TriggerService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Trigger")
@Api(tags = "触发器模块")
public class TriggerController {
    @Resource
    public TriggerService triggerService;

    @PostMapping("/AddTrigger")
    @ApiOperation("添加触发器")
    public ApiRes<String> AddTrigger(@RequestBody @Validated(ValidationApi.add.class) UpdateTriggerReq req) {
        return ApiRes.success(triggerService.addTrigger(req));
    }
    @PostMapping("/UpdateTrigger")
    @ApiOperation("修改触发器")
    public ApiRes<Boolean> UpdateTrigger(@RequestBody @Validated(ValidationApi.edit.class) UpdateTriggerReq req) {
        return ApiRes.success(triggerService.updateTrigger(req));
    }
    @PostMapping("/DeleteTrigger")
    @ApiOperation("删除触发器")
    public ApiRes<Boolean> DeleteTrigger(@RequestBody @Validated(ValidationApi.delete.class) UpdateTriggerReq req) {
        return ApiRes.success(triggerService.deleteTrigger(req));
    }
    @PostMapping("/ChangeTriggerState")
    @ApiOperation("禁用启用触发器")
    public ApiRes<Boolean> ChangeTriggerState(@RequestBody @Validated(ValidationApi.updateStatus.class) UpdateTriggerReq req) {
        return ApiRes.success(triggerService.changeTriggerState(req));
    }
    @PostMapping("/GetTriggerList")
    @ApiOperation("查询触发器列表")
    public ApiRes<List<Trigger>> GetTriggerList(@RequestBody @Validated(ValidationApi.updateStatus.class) QueryTriggerReq req) {
        return ApiRes.success(triggerService.getTriggerList(req));
    }
}
