package com.junmp.jyzb.api.bean.query;

import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class LogDetailReq {

    /**
     * 出入库明细ID
     */
    private Long id;

    /**
     * 物资id
     */
    private String inventoryId;

    /**
     * 出入库汇总ID
     */
    @NotNull(message = "出入库记录汇总id不能为空",groups = {ValidationApi.detail.class})
    private Long summaryId;


    /**
     * EPC信息
     */
    private String epc;

    /**
     * 装备名称
     */
    private String equipmentName;

    /**
     * 装备号型
     */
    private String equipmentSize;

    /**
     * 供应商
     */
    private String equipmentSupplier;

    /**
     * 装备类型:0单件/1装备包
     */
    private Integer equipmentType;

    /**
     * 状态，0正常/1异常
     */
    private Integer errorState;


    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 照片信息
     */
    private String picture;

    /**
     * 作业设备：0手持机 1单警柜 2通道）
     */
    private Integer deviceType;

}
