package com.junmp.jyzb.mapper;

import com.junmp.jyzb.domain.Policeman;
import com.junmp.jyzb.domain.Warehouse;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface WarehouseMapper {

    public int addWarehouse(Warehouse warehouse);

    Map<String, Object> getOneWarehouse(String id);

    void deleteWarehouse(String id);

    void updateWarehouse(Warehouse warehouse);

    List<String> getAllWarehouseId(String orgId);

    void changeWarehouseState(Warehouse warehouse);

    List<String> getAllWarehouseIdByHighest();

    List<Map<String, Object>> getAllWarehouse();

    List<Map<String, Object>> getAllWarehouseByOrgList(List<String> allOrgId);

    void setWarehouseSumInventory(@Param("updateId") String id);

    void setWarehouseInSumInventory(@Param("updateId") String id);

    void setWarehouseOutSumInventory(@Param("updateId") String id);

    void setWarehousePriceInventory(@Param("updateId") String id);
}