package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-Warehouse")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Warehouse implements Serializable {
    /**
     * 仓库信息表
     */
    @ApiModelProperty(value = "仓库信息表")
    private String id;

    /**
     * 仓库名称
     */
    @ApiModelProperty(value = "仓库名称")
    private String name;

    /**
     * 仓库地点
     */
    @ApiModelProperty(value = "仓库地点")
    private String location;

    /**
     * 联系方式
     */
    @ApiModelProperty(value = "联系方式")
    private String phone;

    /**
     * 视屏地址
     */
    @ApiModelProperty(value = "视屏地址")
    private String video;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    /**
     * 更新人员
     */
    @ApiModelProperty(value = "更新人员")
    private String updateUser;

    /**
     * 新版本组织机构外键
     */
    @ApiModelProperty(value = "新版本组织机构外键")
    private Integer orgIdInt;

    /**
     * 是否锁库，1锁库，0未锁库
     */
    @ApiModelProperty(value = "是否锁库")
    private Integer isLocked;

    /**
     * 组织机构表id
     */
    @ApiModelProperty(value = "组织机构表id")
    private String orgId;

    /**
     * 当前仓库下装备总数
     */
    @ApiModelProperty(value = "当前仓库下装备总数")
    private Integer sum;

    /**
     * 出库装备总数
     */
    @ApiModelProperty(value = "当前仓库下装备总数")
    private Integer outSum;

    /**
     * 出库装备总数
     */
    @ApiModelProperty(value = "当前仓库下装备总数")
    private Integer inSum;

    /**
     * 1表启用，0表禁用
     */
    @ApiModelProperty(value = "状态")
    private Integer state;



    private static final long serialVersionUID = 1L;
}