package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-Inventory")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Inventory implements Serializable {
    /**
     * 装备ID
     */
    @ApiModelProperty(value = "装备ID")
    private String id;

    /**
     * 装备包ID
     */
    @ApiModelProperty(value = "装备包ID")
    private String packageId;

    /**
     * 装备类型ID
     */
    @ApiModelProperty(value = "装备类型ID")
    private String typeId;

    /**
     * 装备类型名称
     */
    @ApiModelProperty(value = "装备类型名称")
    private String typeName;

    /**
     * 号型ID
     */
    @ApiModelProperty(value = "号型ID")
    private String sizeId;

    /**
     * 供应商ID
     */
    @ApiModelProperty(value = "供应商ID")
    private String supplierId;

    /**
     * 供应商名称
     */
    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    /**
     * 货架ID
     */
    @ApiModelProperty(value = "货架ID")
    private String shelfId;

    /**
     * 区域信息
     */
    @ApiModelProperty(value = "区域信息")
    private String locationArea;

    /**
     * 位置信息
     */
    @ApiModelProperty(value = "位置信息")
    private String positionMsg;

    /**
     * EPC信息
     */
    @ApiModelProperty(value = "EPC信息")
    private String epc;

    /**
     * 组织机构ID
     */
    @ApiModelProperty(value = "组织机构ID")
    private String orgId;

    /**
     * 组织机构名称
     */
    @ApiModelProperty(value = "组织机构名称")
    private String orgName;

    /**
     * 状态:0正常/1损坏/2报废/3销毁
     */
    @ApiModelProperty(value = "状态:0正常/1损坏/2报废/3销毁")
    private Integer state;

    /**
     * 业务状态:0无业务,1调拨/借用/领用
     */
    @ApiModelProperty(value = "业务状态:0无业务,1调拨/借用/领用")
    private Integer bussinessState;

    /**
     * 在库状态:0在库，1出库
     */
    @ApiModelProperty(value = "在库状态:0在库，1出库")
    private Integer locationState;

    /**
     * 生产日期
     */
    @ApiModelProperty(value = "生产日期")
    private Date productionDate;

    /**
     * 质保期
     */
    @ApiModelProperty(value = "质保期")
    private Integer warrantyPeriod;

    /**
     * 维保期
     */
    @ApiModelProperty(value = "维保期")
    private Integer maintenancePeriod;

    /**
     * 维修次数
     */
    @ApiModelProperty(value = "维修次数")
    private Integer fixCount;

    /**
     * 价格
     */
    @ApiModelProperty(value = "价格")
    private String price;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String note;

    private static final long serialVersionUID = 1L;
}