package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-CabinetBox")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CabinetBox implements Serializable {
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 主柜ID
     */
    @ApiModelProperty(value = "主柜ID")
    private String cabinetId;

    /**
     * 警员ID
     */
    @ApiModelProperty(value = "警员ID")
    private String policeId;

    /**
     * 警员姓名
     */
    @ApiModelProperty(value = "警员姓名")
    private String policeName;

    /**
     * 异常状态:1正常/0异常
     */
    @ApiModelProperty(value = "异常状态:1正常/0异常")
    private Integer state;

    /**
     * 异常原因
     */
    @ApiModelProperty(value = "异常原因")
    private String errorMsg;

    /**
     * 使用日志存储位置信息
     */
    @ApiModelProperty(value = "使用日志存储位置信息")
    private String logMap;

    private static final long serialVersionUID = 1L;
}