package com.junmp.jyzb.controller;

import com.junmp.jyzb.domain.Policeman;
import com.junmp.jyzb.service.PoliceFingerService;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnData;
import com.junmp.jyzb.utils.ReturnMsg;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Police")
@Api(tags = "警员基础信息模块")
public class PoliceController {

    @Resource
    public PolicemanService policemanService;

    @PostMapping("/AddPoliceman")
    @ApiOperation("添加警员信息")
    public ResponseResult addPoliceman(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.addPoliceman(msg);
        return returnMsg;
    }

    @PostMapping("/AddFingerInfo")
    @ApiOperation("添加指纹信息")
    public ResponseResult addFingerInfo(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.addFingerInfo(msg);
        return returnMsg;
    }

    @PostMapping("/AddFaceInfo")
    @ApiOperation("添加警员面部信息")
    public ResponseResult addFaceInfo(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.addFaceInfo(msg);
        return returnMsg;
    }

    @PostMapping("/DeletePolice")
    @ApiOperation("删除警员信息")
    public ResponseResult deletePolice(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.deletePolice(msg);
        return returnMsg;
    }

    @PostMapping("/ChangePoliceState")
    @ApiOperation("修改警员状态")
    public ResponseResult ChangePoliceState(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.changePoliceState(msg);
        return returnMsg;
    }

    @PostMapping("/ShowPolice")
    @ApiOperation("查询警员列表")  //根据组织机构id查询
    public ResponseResult getAllPoliceman(@RequestBody Map<String, Object> orgId){
        ResponseResult returnMsg = policemanService.getAllPoliceman(orgId);
        return returnMsg;
    }

    @PostMapping("/GetPoliceDetail")
    @ApiOperation("查询单个警员信息")
    public ResponseResult getOnePolice(@RequestBody Map<String, Object> msg) {
        ResponseResult returnMsg = policemanService.getOnePolice(msg);
        return returnMsg;
    }

    @PostMapping("/UpdatePolice")
    @ApiOperation("修改警员信息")
    public ResponseResult updatePolice(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.updatePolice(msg);
        return returnMsg;
    }

    @PostMapping("/DeleteFingerInfo")
    @ApiOperation("删除警员指纹信息")
    public ResponseResult deletePoliceFinger(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg= policemanService.deleteFinger(msg);
        return returnMsg;
    }

    //todo 更新查询所有
    @PostMapping("/GetPoliceData")
    @ApiOperation("查询与单警柜绑定的警员信息")  //根据单警柜id查询
    public ResponseResult getPoliceData(@RequestBody Map<String, Object> cabinetId){
        //获取该组织机构下所有警员的id
        ResponseResult returnMsg =policemanService.getPoliceData(cabinetId);
        return returnMsg;
    }

    @PostMapping("/ChangePoliceOrg")
    @ApiOperation("警员调岗")
    public ResponseResult changePoliceOrg(@RequestBody Map<String, Object> cabinetId){

        return null;
    }
}
