package com.junmp.jyzb.controller;

import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Size")
@Api(tags = "号型基础信息模块")
public class EquipmentSizeController {
    @Resource
    public EquipmentSizeService equipmentSizeService;

    @PostMapping("/AddSize")
    @ApiOperation("添加号型信息")
    public ResponseResult addSize(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = equipmentSizeService.addSize(msg);
        return returnMsg;
    }

    @PostMapping("/DeleteSize")
    @ApiOperation("删除号型信息")
    public ResponseResult deleteSize(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = equipmentSizeService.deleteSize(msg);
        return returnMsg;
    }

    @PostMapping("/GetOneSize")
    @ApiOperation("查询单个号型信息")
    public ResponseResult getOneSize(@RequestBody Map<String, Object> msg) {
        ResponseResult returnMsg = equipmentSizeService.getOneSize(msg);
        return returnMsg;
    }

    @PostMapping("/ShowSize")
    @ApiOperation("根据装备类型查询号型")
    public ResponseResult getAllSize(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = equipmentSizeService.getAllSize(msg);
        return returnMsg;
    }

    @PostMapping("/UpdateSize")
    @ApiOperation("修改号型信息")
    public ResponseResult updateSize(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = equipmentSizeService.updateSize(msg);
        return returnMsg;
    }

    @PostMapping("/ChangeSizeState")
    @ApiOperation("禁用/启用装备号型")
    public ResponseResult changeSizeState(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = equipmentSizeService.changeSizeState(msg);
        return returnMsg;
    }

    @PostMapping("/GetSizeDevelop")
    @ApiOperation("获取号型表所有信息(非树表)")
    public ResponseResult getSizeDevelop() {
        ResponseResult returnMsg = equipmentSizeService.getSizeDevelop();
        return returnMsg;
    }
}
