package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.validator.api.validators.unique.TableUniqueValue;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/2 10:11
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ProductBatchReq extends BaseRequest {


    /**
     * 批次主键
     */
    @NotNull(message = "批次主键不能为空", groups = {edit.class, delete.class, detail.class})
    private Long batchId;

    /**
     * 批次编号
     */
    @NotBlank(message = "批次号不能为空", groups = {edit.class})
    @TableUniqueValue(
            message = "批次号重复",
            groups = {edit.class},
            tableName = "biz_product_batch",
            columnName = "batch_no",
            idFieldName = "batch_id")
    private String batchNo;


    /**
     * 产品编号
     */
    @NotNull(message = "批次主键不能为空", groups = {edit.class, add.class})
    private Long productId;

    /**
     * 关联号型
     */
    private Long specId;

    /**
     * 生产总量
     */
    @NotNull(message = "批次主键不能为空", groups = {edit.class, add.class})
    private Integer total;

    /**
     * 序号前缀
     */
    private String prefix;
}
