package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.EquipmentSizeDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.SizeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentSizeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentSizeReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.EquipmentSize;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface EquipmentSizeMapper extends BaseMapper<EquipmentSize> {


    /**
     * 获取分页的信息
     */
    public List<EquipmentSizeDto> getSizePage(
            @Param("req") QueryEquipmentSizeReq req,
            @Param("page") Page<EquipmentSizeDto> page
    );

    /**
     * 获取分页的信息
     */
    public Integer getSizeCount(
            @Param("name") String name,
            @Param("typeId") String typeId
    );

    //根据typeId返回号型名称
    List<String> searchByTypeIds(@Param("list") List<String> typeIdsList);

    List<SizeDto> alignSizeInfo(@Param("req") UpdateEquipmentSizeReq req);
}