package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum InventoryExceptionEnum implements IExceptionEnum {
    INVENTORY_NOT_EXIST(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"装备信息不存在"),
    INVENTORY_BEYOND_STOCK(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"填写的报废的装备数量大于实际能进行报废的数量"),
    BROKENNUM_BEYOND_STOCK(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"审核中的数量已存在最大可报废数量，现提交失败"),
    ORDER_NOT_EXIST(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"盘点单据不存在"),
    ORDER_HAS_START(CommonConstant.DEFAULT_BIZ_ERROR_CODE,"单据已经开始，请勿重复操作"),
    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    InventoryExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
