package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class UpdateEquipmentSizeReq {

    @NotBlank(message = "装备号型主键不能为空", groups = {ValidationApi.edit.class, ValidationApi.delete.class, ValidationApi.detail.class})
    private String id;
    @NotBlank(message = "装备类型id不能为空", groups = {ValidationApi.edit.class,  ValidationApi.add.class})
    private String typeId;
    @NotBlank(message = "编码不能为空", groups = {ValidationApi.edit.class,  ValidationApi.add.class})
    private String code;
    @NotBlank(message = "名称不能为空", groups = {ValidationApi.edit.class,  ValidationApi.add.class})
    private String name;

    private String note;

    private BigDecimal price;
    @NotBlank(message = "状态值不能为空", groups = {ValidationApi.updateStatus.class})
    private String state;

    private String photo;

    private String instructions;
    private Date updateTime;
}
