package com.junmp.jyzb.config;


import com.junmp.jyzb.listener.GlobalEndListener;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

import javax.annotation.Resource;

@Configuration
public class FlowableGlobListenerConfig implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private SpringProcessEngineConfiguration configuration;
    @Resource
    @Autowired
    private GlobalEndListener endListener;

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        FlowableEventDispatcher dispatcher = configuration.getEventDispatcher();
        //任务创建全局监听
//        dispatcher.addEventListener(endListener, FlowableEngineEventType.TASK_COMPLETED);
//        dispatcher.addEventListener(endListener, FlowableEngineEventType.TASK_CREATED);
        dispatcher.addEventListener(endListener, FlowableEngineEventType.PROCESS_COMPLETED);
    }
}
