package com.junmp.junmpProcess.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.junmp.junmpProcess.service.ISysFormService;
import com.junmp.junmpProcess.vo.ProcessVO;
import com.junmp.junmpProcess.vo.TemplateGroupVo;
import com.junmp.junmpProcess.vo.UpdateProcessVO;
import com.junmp.jyzb.api.bean.query.ProcessReq.FormReq;
import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Slf4j
@RestController
@RequestMapping("/SysForm")
@Api(tags = "[工作流]流程编辑")
public class SysFormController {
    @Autowired
    private ISysFormService SysFormService;

    @ApiOperation("创建新表单")
    @PostMapping("CreateForm")
    public ApiRes<Boolean> CreateForm(@RequestBody FormReq formReq) {
        return ApiRes.success(SysFormService.createNewForm(formReq));
    }

    @ApiOperation("同时创建流程和表单")
    @PostMapping(value = "Create")

    public ApiRes<Boolean> Create(@RequestBody ProcessVO processVO) throws JsonProcessingException {
        return ApiRes.success(SysFormService.createBpmn(processVO));
    }
    /**
     * 修改表单名称和备注
     */
    @ApiOperation("修改表单名称和备注")
    @PostMapping("UpdateFormName")
    public ApiRes<Boolean> UpdateFormName(@RequestBody UpdateProcessVO process) throws JsonProcessingException {
        return  ApiRes.success(SysFormService.updateFormName(process));
    }
    @ApiOperation("获取全部可用的表单和审核流")
    @PostMapping(value = "GetFormList")
    public ApiRes<PageResult<TemplateGroupVo>> GetFormList(@RequestBody BaseRequest br) {
        return ApiRes.success(SysFormService.getFormList(br));
    }

}
