package com.junmp.jyzb.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.EqsSumDto;
import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.TjDto.*;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgCountReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgEqsReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgPoliceReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgPriceReq;
import com.junmp.jyzb.api.bean.vo.InOrderInfo;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.service.TjService;
import com.junmp.v2.common.util.HttpServletUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.office.api.OfficeExcelApi;
import com.junmp.v2.office.api.bean.ExcelExportParam;
import liquibase.pro.packaged.Z;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class TjServiceImpl implements TjService {

    @Resource
    private InventorySummaryMapper inventorySummaryMapper;

    @Resource
    private PriceSumSummaryMapper priceSumSummaryMapper;

    @Resource
    private EquipmentCountSummaryMapper equipmentCountSummaryMapper;

    @Resource
    private LogSummaryMapper logSummaryMapper;

    @Resource
    private PoliceEquipmentMapper policeEquipmentMapper;
    @Resource
    private PubOrgService pubOrgService;
    @Resource
    private OfficeExcelApi officeExcelApi;


    //装备统计报表
    @Override
    public List<TjOrgEqsDto> showOrgEqsList(InventoryReq req) {
        //我先查询出他组织机构id中的数据，然后放在list的第一个，然后将他的下一层全部查询出来以后，根据组织机构编号进行比较，最终输出一个有序的list返回
        List<TjOrgEqsDto> list= inventorySummaryMapper.getByOrgId(req.getOrgId());
        List<Long> collect1 = list.stream().map(tjOrgEqsDto -> {
            Long orgId=tjOrgEqsDto.getOrgId();
            return orgId;
        }).collect(Collectors.toList());
        //将组织机构下库存信息信息查询出来
        List<EqsSumDto> childrenList=inventorySummaryMapper.getEqsByOrgId(collect1,req.getTypeId(),req.getSizeId());

        Map<Long, List<EqsSumDto>> eqsSumDtoMap = new HashMap<>();
        for (EqsSumDto eqsSumDto : childrenList) {
            Long orgId = eqsSumDto.getOrgId();
            if (eqsSumDtoMap.containsKey(orgId)) {
                List<EqsSumDto> eqsSumDtoList = eqsSumDtoMap.get(orgId);
                eqsSumDtoList.add(eqsSumDto);
            } else {
                List<EqsSumDto> eqsSumDtoList = new ArrayList<>();
                eqsSumDtoList.add(eqsSumDto);
                eqsSumDtoMap.put(orgId, eqsSumDtoList);
            }
        }

        for (TjOrgEqsDto tjOrgEqsDto : list) {
            Long orgId = tjOrgEqsDto.getOrgId();
            if (eqsSumDtoMap.containsKey(orgId)) {
                List<EqsSumDto> eqsSumDtoList = eqsSumDtoMap.get(orgId);
            }
        }
        //对查询的组织机构进行有序排列
        List<TjOrgEqsDto> collect = list.stream()
                .sorted((o1, o2) -> {
                    String orgCode1 = o1.getOrgCode();
                    String orgCode2 = o2.getOrgCode();

                    // Check if either orgCode contains letters
                    boolean hasLetter1 = orgCode1.matches(".*[a-zA-Z].*");
                    boolean hasLetter2 = orgCode2.matches(".*[a-zA-Z].*");

                    if (hasLetter1 && hasLetter2) {
                        return orgCode1.compareTo(orgCode2); // Alphabetical order
                    } else if (hasLetter1) {
                        return 1; // o2 with letters should come first
                    } else if (hasLetter2) {
                        return -1; // o1 with letters should come first
                    } else {
                        return orgCode1.compareTo(orgCode2); // Numeric order
                    }
                })
                .collect(Collectors.toList());

        return collect;
    }

    @Override
    public FinalTjOrgEqsDto test(TjOrgEqsReq req) {
        List<String> typeIdsList = req.getTypeIdsList();
        List<String> sizeNameList = req.getSizeNameList();
//        int size = typeIdsList.size();
//        int size1 = sizeNameList.size();
        boolean notNull = ObjectUtil.isNotNull(req.getTypeIdsList());
        boolean s = ObjectUtil.isNotNull(req.getSizeNameList());
//        System.out.println("yiyi = " + req.getTypeIdsList().isEmpty());
        System.out.println("yiyi = " + ObjectUtil.isEmpty(req.getTypeIdsList()));
//        System.out.println("yiyi = " + req.getTypeIdsList().isEmpty());
        return null;
    }

//    @Override
//    public List<TjOrgEqsDto> test(InventoryReq req) {
//        List<TjOrgEqsDto> tJOrgEqsDtoList = inventorySummaryMapper.test(req);
//        List<TjOrgEqsDto> dynamicViewList = inventorySummaryMapper.selectDynamicView();
//        return dynamicViewList;
//    }


    @Override
    public PageResult<TjOrgEqsDto> GetTjData(TjOrgEqsReq req) {
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        //先拿到符合条件的组织机构，再遍历组织机构组成数据
        //（下一层数据组织机构数据）
       List<String> orgList= inventorySummaryMapper.getTotalData(String.valueOf(req.getOrgId()));
       List<TjOrgEqsDto> allData=new ArrayList<>();
        for (String orgId:orgList) {

            TjOrgEqsDto OrgData=inventorySummaryMapper.GetInvSum( orgId,
                    req.getTypeIdsList().isEmpty() ? null : req.getTypeIdsAsString(),
                    req.getSizeNameList().isEmpty() ? null : req.getSizesAsString());
            allData.add(OrgData);
        }
        if (req.getOrgId()!=1369509498032808905L)
        {

            TjOrgEqsDto OrgData = inventorySummaryMapper.GetSumLeve4(String.valueOf(req.getOrgId()),
                    req.getTypeIdsList().isEmpty() ? null : req.getTypeIdsAsString(),
                    req.getSizeNameList().isEmpty() ? null : req.getSizesAsString(),pubOrg.getLevelFlag());
            allData.add(OrgData);//把本级数据加进去
        }
        //查询出来的组织机构进行判断，如果该组织机构下的装备装备总数为0，那么将该组织机构从list中移除
        if (req.getRemoveEmpty())
        {
            allData.removeIf(tjOrgEqsDto -> tjOrgEqsDto.getTotalNumber() == 0);
        }


        //将组织机构进行排序后再进行返回
        Comparator<TjOrgEqsDto> orgComparator = createOrgComparator();
        Collections.sort(allData, orgComparator);

        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        Page<TjOrgEqsDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        long startIndex = (req.getPageNo() - 1) * req.getPageSize();
        long endIndex = Math.min(startIndex + req.getPageSize(), allData.size());
        List<TjOrgEqsDto> subList = allData.subList((int)startIndex, (int)endIndex);
        page.setRecords(subList);
        page.setTotal(allData.size());
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public FinalTjOrgEqsDto TjOrgDataSum(TjOrgEqsReq req) {
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        FinalTjOrgEqsDto finalTjOrgEqsDto = new FinalTjOrgEqsDto();
        finalTjOrgEqsDto.setTotalNumber(0);
        finalTjOrgEqsDto.setCkStockNumber(0);
        finalTjOrgEqsDto.setCkOutboundNumber(0);
        finalTjOrgEqsDto.setDjgOutboundNumber(0);
        finalTjOrgEqsDto.setDjgStockNumber(0);
        List<String> orgList= inventorySummaryMapper.getTotalData(String.valueOf(req.getOrgId()));
        List<TjOrgEqsDto> allData=new ArrayList<>();
        for (String orgId:orgList) {

            TjOrgEqsDto OrgData=inventorySummaryMapper.GetInvSum( orgId,
                    req.getTypeIdsList().isEmpty() ? null : req.getTypeIdsAsString(),
                    req.getSizeNameList().isEmpty() ? null : req.getSizesAsString());
            allData.add(OrgData);
        }
        if (!req.getOrgId().equals("1369509498032808905"))
        {

            TjOrgEqsDto OrgData = inventorySummaryMapper.GetSumLeve4(String.valueOf(req.getOrgId()),
                    req.getTypeIdsList().isEmpty() ? null : req.getTypeIdsAsString(),
                    req.getSizeNameList().isEmpty() ? null : req.getSizesAsString(),pubOrg.getLevelFlag());
            allData.add(OrgData);//把本级数据加进去
        }
        for (TjOrgEqsDto tj:allData) {
            finalTjOrgEqsDto.setTotalNumber(finalTjOrgEqsDto.getTotalNumber()+ tj.getTotalNumber());
            finalTjOrgEqsDto.setCkStockNumber(finalTjOrgEqsDto.getCkStockNumber()+ tj.getCkStockNumber());
            finalTjOrgEqsDto.setCkOutboundNumber(finalTjOrgEqsDto.getCkOutboundNumber()+ tj.getCkOutboundNumber());
            finalTjOrgEqsDto.setDjgOutboundNumber(finalTjOrgEqsDto.getDjgOutboundNumber()+ tj.getDjgOutboundNumber());
            finalTjOrgEqsDto.setDjgStockNumber(finalTjOrgEqsDto.getDjgStockNumber()+ tj.getDjgStockNumber());
        }
        return finalTjOrgEqsDto;
    }



    //    @Override
    public List<TjOrgEqsDto> GetTjDataDetail(TjOrgEqsReq req) {

        //先拿到符合条件的组织机构，再遍历组织机构组成数据

        List<TjOrgEqsDto> allData=new ArrayList<>();
       List<TjOrgEqsDto> OrgData=inventorySummaryMapper.getTotalDataDetail(String.valueOf(req.getOrgId()),req.getTypeIdsList(),req.getSizeNameList(),req.getLevelNum());
        allData.addAll(OrgData);//把本级数据加进去
        if (req.getRemoveEmpty())//如果需要删除数据为0的话，前端传true，否则保留数据为0
        {
            allData.removeIf(tjOrgEqsDto -> tjOrgEqsDto.getTotalNumber() == 0);
        }
        //将组织机构进行排序后再进行返回
        Comparator<TjOrgEqsDto> orgComparator = createOrgComparator();
        Collections.sort(allData, orgComparator);
        return allData;
    }

//    @Override
//    public PageResult<TjOrgEqsDto> TjOrgEqs(TjOrgEqsReq req) {
//        //我得先将typeid传递的最下层的装备idlist拿到
////        List<String> typeIdsList = equipmentSizeService.selectByTypeIds(req.getTypeIdsList());
////        List<String> sizeNameList = req.getSizeNameList();
//        //将前端传递的值进行处理并且执行存储过程
//        String sql="and (org_id="+req.getOrgId()+" or org_parent_id = "+req.getOrgId()+")";
//        String sql1 = setSql(req);
////        System.out.println("sql = " + sql);
//        //执行存储过程
//        inventorySummaryMapper.useViewOrgeqs(sql,req.getOrgId(),sql1);
//        //查询视图
//        List<TjOrgEqsDto> tjOrgEqsDtoList = inventorySummaryMapper.selectViewOrgeqsSum();
//        //查询出来的组织机构进行判断，如果该组织机构下的装备装备总数为0，那么将该组织机构从list中移除
//        tjOrgEqsDtoList.removeIf(tjOrgEqsDto -> tjOrgEqsDto.getTotalNumber() == 0);
//        //将组织机构进行排序后再进行返回
//        Comparator<TjOrgEqsDto> orgComparator = createOrgComparator();
//        Collections.sort(tjOrgEqsDtoList, orgComparator);
//
//        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
//            req.setPageNo(1L);
//            req.setPageSize(10L);
//        }
//        Page<TjOrgEqsDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
//        long startIndex = (req.getPageNo() - 1) * req.getPageSize();
//        long endIndex = Math.min(startIndex + req.getPageSize(), tjOrgEqsDtoList.size());
//        List<TjOrgEqsDto> subList = tjOrgEqsDtoList.subList((int)startIndex, (int)endIndex);
////        List<TjOrgEqsDto> subList = tjOrgEqsDtoList.subList((int) ((req.getPageNo()-1)*req.getPageSize()), req.getPageSize().intValue());
//        page.setRecords(subList);
//        page.setTotal(tjOrgEqsDtoList.size());
////        finalTjOrgEqsDto.setTjOrgEqsDto(tjOrgEqsDtoList);
//        return PageResultFactory.createPageResult(page);
//    }

//    @Override
//    public List<TjOrgEqsDto> TjOrgEqsSecondList(TjOrgEqsReq req) {
//
//        List<TjOrgEqsDto> tjOrgEqsDtoList=new ArrayList<>();
//        String sql="and (org_id="+req.getOrgId()+" or org_parent_id = "+req.getOrgId()+")";
//        String sql1 = setSql(req);
//        if (req.getOrgId().compareTo(req.getParentOrgId())==0){
//
//            inventorySummaryMapper.useViewOrgIdInLevel(sql,req.getOrgId());
//
//        }else {
//
//            inventorySummaryMapper.useViewOrgIdInSubordinate(sql);
//
//        }
//        //查询视图
//        tjOrgEqsDtoList = inventorySummaryMapper.selectViewOrgeqsSum();
//        if (CollectionUtil.isNotEmpty(tjOrgEqsDtoList)){
//            //查询出来的组织机构进行判断，如果该组织机构下的装备装备总数为0，那么将该组织机构从list中移除
//            tjOrgEqsDtoList.removeIf(tjOrgEqsDto -> tjOrgEqsDto.getTotalNumber() == 0);
//            //将组织机构进行排序后再进行返回
//            Comparator<TjOrgEqsDto> orgComparator = createOrgComparator();
//            Collections.sort(tjOrgEqsDtoList, orgComparator);
//        }
//        return tjOrgEqsDtoList;
//    }



    @Override
    public PageResult<TjOrgEqsDto> test1(TjOrgEqsReq req) {
        List<Long> orgIds=inventorySummaryMapper.selectOrgIds(req.getOrgId());
        for (Long orgId:orgIds) {

        }
        return null;
    }

    //装备统计数据导出
    @Override
    public void TjOrgEqsExport(TjOrgEqsReq req) {
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        //先拿到符合条件的组织机构，再遍历组织机构组成数据
        //（下一层数据组织机构数据）
        List<String> orgList= inventorySummaryMapper.getTotalData(String.valueOf(req.getOrgId()));
        List<TjOrgEqsDto> allData=new ArrayList<>();
        for (String orgId:orgList) {
            TjOrgEqsDto OrgData=inventorySummaryMapper.GetInvSum( orgId,
                    req.getTypeIdsList().isEmpty() ? null : req.getTypeIdsAsString(),
                    req.getSizeNameList().isEmpty() ? null : req.getSizesAsString());
            allData.add(OrgData);
        }
        if (req.getOrgId()!=1369509498032808905L) {

            TjOrgEqsDto OrgData = inventorySummaryMapper.GetSumLeve4(String.valueOf(req.getOrgId()),
                    req.getTypeIdsList().isEmpty() ? null : req.getTypeIdsAsString(),
                    req.getSizeNameList().isEmpty() ? null : req.getSizesAsString(),pubOrg.getLevelFlag());
            allData.add(OrgData);//把本级数据加进去
        }
        //查询出来的组织机构进行判断，如果该组织机构下的装备装备总数为0，那么将该组织机构从list中移除
        if (req.getRemoveEmpty()) {
            allData.removeIf(tjOrgEqsDto -> tjOrgEqsDto.getTotalNumber() == 0);
        }
        //将组织机构进行排序后再进行返回
        Comparator<TjOrgEqsDto> orgComparator = createOrgComparator();
        Collections.sort(allData, orgComparator);
        List<TjOrgEqsDto> collect=new ArrayList<>() ;
        for (TjOrgEqsDto tjOrgEqsDto:allData) {
            List<TjOrgEqsDto> tjOrgEqsDtos = GetTjDataDetail(req);
            for (int i = 1; i <= tjOrgEqsDtos.size() ; i++) {
                collect.get(i-1).setNumId(i);
            }
            collect.addAll(tjOrgEqsDtos);
        }
        HttpServletResponse response = HttpServletUtil.getResponse();
        ExcelExportParam param = new ExcelExportParam();
        param.setDataList(collect);
        param.setClazz(InOrderInfo.class);
        param.setResponse(response);
        param.setFileName("入库单据列表.xls");
        //对数据进行导出

        officeExcelApi.easyExportDownload(param);

    }



    private String setSql(TjOrgEqsReq req){

        String sql="and 1=1";
//        if (!ObjectUtil.isEmpty(req.getTypeIdsList()) && req.getTypeIdsList().size()>0){
//            sql+="and type_id in (";
//            for (String typeId:req.getTypeIdsList()) {
//                sql+=typeId+",";
//            }
//            sql = sql.substring(0, sql.length() - 1);
//            sql+=")";
//        }
//        if (!ObjectUtil.isEmpty(req.getSizeNameList()) && req.getSizeNameList().size()>0){
//            sql+="and size_name in (";
//            for (String sizeName:req.getSizeNameList()) {
//                sql+="'"+sizeName+"',";
//            }
//            sql = sql.substring(0, sql.length() - 1);
//            sql+=")";
//        }
        return sql;
    }

    //查看装备统计详情
    @Override
    public PageResult<InventorySumDto> TjOrgEqsDetailPage(TjOrgEqsReq req) {
        int size = inventorySummaryMapper.TjOrgEqsDetailSum(req.getOrgId(), req.getTypeIdsList(), req.getSizeNameList());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        Page<InventorySumDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        List<InventorySumDto> returnList=inventorySummaryMapper.TjOrgEqsDetail(req.getOrgId(),req.getTypeIdsList(),
                req.getSizeNameList(),(req.getPageNo()-1)* req.getPageSize(),req.getPageSize());
        page.setTotal(size);
        page.setRecords(returnList);
        return PageResultFactory.createPageResult(page);
    }

    //查看装备统计详情
    @Override
    public List<InventorySumDto> TjOrgEqsDetailList(TjOrgEqsReq req) {
        List<InventorySumDto> returnList=inventorySummaryMapper.TjOrgEqsDetail(req.getOrgId(),req.getTypeIdsList(),
                req.getSizeNameList(),null,null);
        return returnList;
    }
//------------------------------------------------财务统计报表--------------------------------------------------------
    //财务统计报表
//    @Override
//    public PageResult<TjOrgPriceDto> TjOrgPrice(TjOrgPriceReq req) {
//        //根据条件查询财务汇总表
//        List<TjOrgPriceDto> tjOrgPriceDtoList=priceSumSummaryMapper.TjOrgPrice(req.getOrgId(), req.getYear(),
//                req.getTypeIdsList(),req.getSizeNameList());
//        //对组织机构进行排序
//        Comparator<TjOrgPriceDto> orgComparator = createOrgComparator();
//        Collections.sort(tjOrgPriceDtoList, orgComparator);
//        Page<TjOrgPriceDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
//        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
//            req.setPageNo(1L);
//            req.setPageSize(10L);
//        }
//        long startIndex = (req.getPageNo() - 1) * req.getPageSize();
//        long endIndex = Math.min(startIndex + req.getPageSize(), tjOrgPriceDtoList.size());
//        List<TjOrgPriceDto> subList = tjOrgPriceDtoList.subList((int) startIndex, (int)endIndex);
////        List<TjOrgPriceDto> subList = tjOrgPriceDtoList.subList((int) ((req.getPageNo()-1)*req.getPageSize()), req.getPageSize().intValue());
//        page.setTotal(tjOrgPriceDtoList.size());
//        page.setRecords(subList);
//        return PageResultFactory.createPageResult(page);
//    }

    @Override
    public PageResult<TjOrgPriceDto> TjOrgPrice(TjOrgPriceReq req) {
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        //先拿到符合条件的组织机构，再遍历组织机构组成数据
        //（下一层数据组织机构数据）
        List<String> orgList= inventorySummaryMapper.getTotalData(String.valueOf(req.getOrgId()));
        List<TjOrgPriceDto> tjOrgPriceDtoList=new ArrayList<>();
        //根据条件查询财务汇总表
        //循环遍历下一级以及它下面的汇总信息
        for (String orgId:orgList) {
            TjOrgPriceDto OrgData=priceSumSummaryMapper.TjOrgPrice(orgId, req.getYear(),req.getTypeIdsList(),req.getSizeNameList() );
            OrgData.setAddNum(ObjectUtil.isNull(OrgData.getAddNum())?0:OrgData.getAddNum());
            OrgData.setEndNum(ObjectUtil.isNull(OrgData.getEndNum())?0:OrgData.getEndNum());
            OrgData.setStartNum(ObjectUtil.isNull(OrgData.getStartNum())?0:OrgData.getStartNum());
            OrgData.setDestoryNum(ObjectUtil.isNull(OrgData.getDestoryNum())?0:OrgData.getDestoryNum());
            OrgData.setStartPrice(ObjectUtil.isNull(OrgData.getStartPrice())?BigDecimal.ZERO:OrgData.getStartPrice());
            OrgData.setEndPrice(ObjectUtil.isNull(OrgData.getEndPrice())?BigDecimal.ZERO:OrgData.getEndPrice());
            OrgData.setAddPrice(ObjectUtil.isNull(OrgData.getAddPrice())?BigDecimal.ZERO:OrgData.getAddPrice());
            OrgData.setDestoryPrice(ObjectUtil.isNull(OrgData.getDestoryPrice())?BigDecimal.ZERO:OrgData.getDestoryPrice());
            tjOrgPriceDtoList.add(OrgData);
        }
        if (req.getOrgId()!=1369509498032808905L){
            TjOrgPriceDto OrgData=priceSumSummaryMapper.TjOrgPriceLeve4(req.getOrgId(), req.getYear(),req.getTypeIdsList(),
                    req.getSizeNameList(),pubOrg.getLevelFlag());
            tjOrgPriceDtoList.add(OrgData);//把本级数据加进去
        }

        //查询出来的组织机构进行判断，如果该组织机构下的装备装备总数为0，那么将该组织机构从list中移除
        if (req.getRemoveEmpty()){
            tjOrgPriceDtoList.removeIf(tjOrgEqsDto -> tjOrgEqsDto.getStartNum() == 0 && tjOrgEqsDto.getEndNum() == 0
                    && tjOrgEqsDto.getDestoryNum()==0);
        }

        //对组织机构进行排序
        Comparator<TjOrgPriceDto> orgComparator = createOrgComparator();
        Collections.sort(tjOrgPriceDtoList, orgComparator);
        Page<TjOrgPriceDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        long startIndex = (req.getPageNo() - 1) * req.getPageSize();
        long endIndex = Math.min(startIndex + req.getPageSize(), tjOrgPriceDtoList.size());
        List<TjOrgPriceDto> subList = tjOrgPriceDtoList.subList((int) startIndex, (int)endIndex);
//        List<TjOrgPriceDto> subList = tjOrgPriceDtoList.subList((int) ((req.getPageNo()-1)*req.getPageSize()), req.getPageSize().intValue());
        page.setTotal(tjOrgPriceDtoList.size());
        page.setRecords(subList);
        return PageResultFactory.createPageResult(page);
    }
    @Override
    public FinalTjOrgPriceDto TjOrgPriceSum(TjOrgPriceReq req) {
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        FinalTjOrgPriceDto finalTjOrgPriceDto = new FinalTjOrgPriceDto();
        finalTjOrgPriceDto.setAddNum(0);
        finalTjOrgPriceDto.setStartNum(0);
        finalTjOrgPriceDto.setEndNum(0);
        finalTjOrgPriceDto.setDestoryNum(0);
        finalTjOrgPriceDto.setAddPrice(BigDecimal.ZERO);
        finalTjOrgPriceDto.setStartPrice(BigDecimal.ZERO);
        finalTjOrgPriceDto.setEndPrice(BigDecimal.ZERO);
        finalTjOrgPriceDto.setDestoryPrice(BigDecimal.ZERO);
        List<String> orgList= inventorySummaryMapper.getTotalData(String.valueOf(req.getOrgId()));
        List<TjOrgPriceDto> tjOrgPriceDtoList=new ArrayList<>();
        //根据条件查询财务汇总表
        for (String orgId:orgList) {
            TjOrgPriceDto OrgData=priceSumSummaryMapper.TjOrgPrice(orgId, req.getYear(),req.getTypeIdsList(),req.getSizeNameList() );
            tjOrgPriceDtoList.add(OrgData);
        }
        if (req.getOrgId()!=1369509498032808905L){
            TjOrgPriceDto OrgData=priceSumSummaryMapper.TjOrgPriceLeve4(req.getOrgId(), req.getYear(),req.getTypeIdsList(),req.getSizeNameList(),pubOrg.getLevelFlag());
            tjOrgPriceDtoList.add(OrgData);//把本级数据加进去
        }
        for (TjOrgPriceDto tj:tjOrgPriceDtoList) {
            tj.setAddNum(ObjectUtil.isNull(tj.getAddNum())?0:tj.getAddNum());
            tj.setStartNum(ObjectUtil.isNull(tj.getStartNum())?0:tj.getStartNum());
            tj.setEndNum(ObjectUtil.isNull(tj.getEndNum())?0:tj.getEndNum());
            tj.setDestoryNum(ObjectUtil.isNull(tj.getDestoryNum())?0:tj.getDestoryNum());
            tj.setStartPrice(ObjectUtil.isNull(tj.getStartPrice())?BigDecimal.ZERO:tj.getStartPrice());
            tj.setAddPrice(ObjectUtil.isNull(tj.getAddPrice())?BigDecimal.ZERO:tj.getAddPrice());
            tj.setEndPrice(ObjectUtil.isNull(tj.getEndPrice())?BigDecimal.ZERO:tj.getEndPrice());
            tj.setDestoryPrice(ObjectUtil.isNull(tj.getDestoryPrice())?BigDecimal.ZERO:tj.getDestoryPrice());
            finalTjOrgPriceDto.setAddNum(finalTjOrgPriceDto.getAddNum()+tj.getAddNum());
            finalTjOrgPriceDto.setStartNum(finalTjOrgPriceDto.getStartNum()+tj.getStartNum());
            finalTjOrgPriceDto.setEndNum(finalTjOrgPriceDto.getEndNum()+tj.getEndNum());
            finalTjOrgPriceDto.setDestoryNum(finalTjOrgPriceDto.getDestoryNum()+tj.getDestoryNum());
            finalTjOrgPriceDto.setAddPrice(finalTjOrgPriceDto.getAddPrice().add(tj.getAddPrice()));
            finalTjOrgPriceDto.setStartPrice(finalTjOrgPriceDto.getStartPrice().add(tj.getStartPrice()));
            finalTjOrgPriceDto.setEndPrice(finalTjOrgPriceDto.getEndPrice().add(tj.getEndPrice()));
            finalTjOrgPriceDto.setDestoryPrice(finalTjOrgPriceDto.getDestoryPrice().add(tj.getDestoryPrice()));
        }
        return finalTjOrgPriceDto;
    }

    @Override
    public List<TjOrgPriceDto> TjOrgPriceDetail(TjOrgPriceReq req) {
        List<TjOrgPriceDto> tjOrgPriceDtoList = priceSumSummaryMapper.TjOrgPriceTotalNum(req.getOrgId(), req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),req.getLevelNum());
        if (req.getRemoveEmpty()){
            tjOrgPriceDtoList.removeIf(tjOrgEqsDto -> tjOrgEqsDto.getStartNum() == 0 && tjOrgEqsDto.getEndNum() == 0
                    && tjOrgEqsDto.getDestoryNum()==0);
        }
        return tjOrgPriceDtoList;
    }


    //查看财务统计详情
    @Override
    public PageResult<TjOrgPriceDto> TjOrgPriceDetailPage(TjOrgPriceReq req) {
        int size = priceSumSummaryMapper.TjOrgPriceDetailSum(req.getOrgId(),req.getYear(),req.getTypeIdsList(),req.getSizeNameList());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        Page<TjOrgPriceDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        List<TjOrgPriceDto> returnList=priceSumSummaryMapper.TjOrgPriceDetail(req.getOrgId(),req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),(req.getPageNo()-1)* req.getPageSize(),req.getPageSize());
        page.setTotal(size);
        page.setRecords(returnList);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public List<TjOrgPriceDto> TjOrgPriceDetailList(TjOrgPriceReq req) {
        List<TjOrgPriceDto> returnList=priceSumSummaryMapper.TjOrgPriceDetail(req.getOrgId(),req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),null,null);
        return returnList;
    }


    public <T> Comparator<T> createOrgComparator() {
        return (org1,org2) ->{

            try {
                String orgCode1 = (String) org1.getClass().getMethod("getOrgCode").invoke(org1);
                String orgCode2 = (String) org2.getClass().getMethod("getOrgCode").invoke(org2);

                // 判断是否包含字母
                boolean hasLetter1 = orgCode1.matches(".*[a-zA-Z]+.*");
                boolean hasLetter2 = orgCode2.matches(".*[a-zA-Z]+.*");

                // 如果其中一个包含字母，则将其放到排序的最后
                if (hasLetter1 && !hasLetter2) {
                    return 1; // orgCode1包含字母，orgCode2不包含字母，orgCode1排在orgCode2后面
                } else if (!hasLetter1 && hasLetter2) {
                    return -1; // orgCode1不包含字母，orgCode2包含字母，orgCode1排在orgCode2前面
                }

                // 如果两个orgCode都不含有字母，则按照每两位进行排序
                String[] orgCodeArray1 = orgCode1.split("(?<=\\G..)");
                String[] orgCodeArray2 = orgCode2.split("(?<=\\G..)");

                // 从最后一组（即最后两位）开始比较数字大小
                int index1 = orgCodeArray1.length - 1;
                int index2 = orgCodeArray2.length - 1;
                while (index1 >= 0 && index2 >= 0) {
                    String codeValue1 = orgCodeArray1[index1];
                    String codeValue2 = orgCodeArray2[index2];

                    // 判断是否可以转换为整数，如果不能，则说明包含字母，直接返回结果
                    try {
                        int intValue1 = Integer.parseInt(codeValue1, 10);
                        int intValue2 = Integer.parseInt(codeValue2, 10);
                        int compareResult = Integer.compare(intValue1, intValue2);
                        if (compareResult != 0) {
                            return compareResult;
                        }
                    } catch (NumberFormatException e) {
                        // orgCode包含字母，直接返回结果
                        return codeValue1.compareTo(codeValue2);
                    }

                    index1--;
                    index2--;
                }

                // 如果orgCode长度不同，那么较长的orgCode排在后面
                return Integer.compare(orgCodeArray1.length, orgCodeArray2.length);
            } catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        };
    }

    @Override
    public PageResult<TjOrgCountDto> TjOrgCount(TjOrgCountReq req) {
        //先拿到符合条件的组织机构，再遍历组织机构组成数据
        //（下一层数据组织机构数据）
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        List<String> orgList= inventorySummaryMapper.getTotalData(String.valueOf(req.getOrgId()));
        List<TjOrgCountDto> tjOrgCountList=new ArrayList<>();
        for (String orgId:orgList) {
            TjOrgCountDto orgData =equipmentCountSummaryMapper.TjOrgCount(orgId,
                    req.getTypeIdsList(),req.getSizeNameList(),req.getYear(),req.getTypeParentId(),req.getMonthList());
            orgData.setNumber(ObjectUtil.isNull(orgData.getNumber())?0:orgData.getNumber());
            orgData.setUseCount(ObjectUtil.isNull(orgData.getUseCount())?0:orgData.getUseCount());
            orgData.setFixCount(ObjectUtil.isNull(orgData.getFixCount())?0:orgData.getFixCount());
            tjOrgCountList.add(orgData);
        }
        if (req.getOrgId()!=1369509498032808905L){
            TjOrgCountDto orgData =equipmentCountSummaryMapper.TjOrgCountleve4(req.getOrgId(),
                    req.getTypeIdsList(),req.getSizeNameList(),req.getYear(),req.getTypeParentId(),req.getMonthList(),pubOrg.getLevelFlag());
            tjOrgCountList.add(orgData);
        }

        //查询出来的组织机构进行判断，如果该组织机构下的装备装备总数为0，那么将该组织机构从list中移除
        if (req.getRemoveEmpty()){
            tjOrgCountList.removeIf(TjOrgCountDto -> TjOrgCountDto.getNumber() == 0 );
        }

        //对组织机构进行排序
        Comparator<TjOrgCountDto> orgComparator = createOrgComparator();
        Collections.sort(tjOrgCountList, orgComparator);
        Page<TjOrgCountDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        long startIndex = (req.getPageNo() - 1) * req.getPageSize();
        long endIndex = Math.min(startIndex + req.getPageSize(), tjOrgCountList.size());
        List<TjOrgCountDto> subList = tjOrgCountList.subList((int) startIndex, (int)endIndex);
        page.setTotal(tjOrgCountList.size());
        page.setRecords(subList);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public FinalTjOrgCountDto TjOrgCountSum(TjOrgCountReq req) {
        FinalTjOrgCountDto finalTjOrgCountDto=new FinalTjOrgCountDto();
        finalTjOrgCountDto.setFixCount(0);
        finalTjOrgCountDto.setUseCount(0);
        finalTjOrgCountDto.setNumber(0);
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        List<String> orgList= inventorySummaryMapper.getTotalData(String.valueOf(req.getOrgId()));
        List<TjOrgCountDto> tjOrgCountList=new ArrayList<>();
        for (String orgId:orgList) {
            TjOrgCountDto orgData =equipmentCountSummaryMapper.TjOrgCount(orgId,
                    req.getTypeIdsList(),req.getSizeNameList(),req.getYear(),req.getTypeParentId(),req.getMonthList());
            orgData.setNumber(ObjectUtil.isNull(orgData.getNumber())?0:orgData.getNumber());
            orgData.setUseCount(ObjectUtil.isNull(orgData.getUseCount())?0:orgData.getUseCount());
            orgData.setFixCount(ObjectUtil.isNull(orgData.getFixCount())?0:orgData.getFixCount());
            tjOrgCountList.add(orgData);
        }
        if (req.getOrgId()!=1369509498032808905L){
            TjOrgCountDto orgData =equipmentCountSummaryMapper.TjOrgCountleve4(req.getOrgId(),
                    req.getTypeIdsList(),req.getSizeNameList(),req.getYear(),req.getTypeParentId(),req.getMonthList(),pubOrg.getLevelFlag());
            tjOrgCountList.add(orgData);
        }
        for (TjOrgCountDto tj:tjOrgCountList) {
            tj.setFixCount(ObjectUtil.isNull(tj.getFixCount())?0: tj.getFixCount());
            tj.setUseCount(ObjectUtil.isNull(tj.getUseCount())?0: tj.getUseCount());
            tj.setNumber(ObjectUtil.isNull(tj.getNumber())?0: tj.getNumber());
            finalTjOrgCountDto.setFixCount(finalTjOrgCountDto.getFixCount()+tj.getFixCount());
            finalTjOrgCountDto.setUseCount(finalTjOrgCountDto.getUseCount()+ tj.getUseCount());
            finalTjOrgCountDto.setNumber(finalTjOrgCountDto.getNumber()+ tj.getNumber());
        }
        return finalTjOrgCountDto;
    }

    @Override
    public List<TjOrgCountDto> TjOrgCountDetail(TjOrgCountReq req) {
        List<TjOrgCountDto> tjOrgCountDtoList=equipmentCountSummaryMapper.TjOrgCountTotalNum(req.getOrgId(),
                req.getTypeIdsList(),req.getSizeNameList(),req.getYear(),req.getTypeParentId(),req.getMonthList(),req.getLevelNum());
        if (req.getRemoveEmpty()){
            tjOrgCountDtoList.removeIf(tjOrgCountDto -> tjOrgCountDto.getNumber()==0 );
        }
        return tjOrgCountDtoList;
    }

    @Override
    public PageResult<TjOrgCountDto> TjOrgCountDetailPage(TjOrgCountReq req) {
        int size = equipmentCountSummaryMapper.TjOrgCountDetailSum(req.getOrgId(),req.getYear(),req.getTypeIdsList(),req.getSizeNameList());
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        Page<TjOrgCountDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        List<TjOrgCountDto> returnList=equipmentCountSummaryMapper.TjOrgCountDetail(req.getOrgId(),req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),(req.getPageNo()-1)* req.getPageSize(),req.getPageSize());
        page.setTotal(size);
        page.setRecords(returnList);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public List<TjOrgCountDto> TjOrgCountDetailList(TjOrgCountReq req) {
        List<TjOrgCountDto> returnList=equipmentCountSummaryMapper.TjOrgCountDetail(req.getOrgId(),req.getYear(),
                req.getTypeIdsList(),req.getSizeNameList(),null,null);
        return returnList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateTjOrgCount(TjOrgCountReq req) {
        String sql=" org_id_int = "+"'"+req.getOrgId()+"'";
        equipmentCountSummaryMapper.deleteAll(req.getOrgId());
        equipmentCountSummaryMapper.addInfo(sql);
        return true;
    }

    @Override
    public List<TjOrgCountDto> TjOrgCountByType(TjOrgCountReq req) {
        return equipmentCountSummaryMapper.TjOrgCountByType(req);
    }

    //首页出入库统计
    @Override
    public List<TjOutAndInDto> TjOutAndInCount(TjOrgCountReq req) {
        List<TjOutAndInDto> returnList=logSummaryMapper.TjOutAndInCount(req);
        return returnList;
    }



    @Override
    public PageResult<TjOrgPoliceDto> TjOrgPolice(TjOrgPoliceReq req) {
        int size=policeEquipmentMapper.getCount(req);
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        List<TjOrgPoliceDto> list= policeEquipmentMapper.TjOrgPolice(req,(req.getPageNo()-1)* req.getPageSize(),req.getPageSize());
        Page<TjOrgPoliceDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page.setTotal(size);
        page.setRecords(list);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public FinalTjOrgPoliceDto TjOrgPoliceSum(TjOrgPoliceReq req) {
        FinalTjOrgPoliceDto finalTjOrgPoliceDto=policeEquipmentMapper.TjOrgPoliceSum(req);
        if (ObjectUtil.isNotNull(finalTjOrgPoliceDto)){
            return finalTjOrgPoliceDto;
        }else {
            return new FinalTjOrgPoliceDto();
        }
    }

//    @Override
//    public PageResult<TjOrgPoliceDto> TjOrgPoliceDetailPage(TjOrgPoliceReq req) {
//        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
//            req.setPageNo(1L);
//            req.setPageSize(10L);
//        }
//        int size = policeEquipmentMapper.TjOrgPoliceDetailSum(req);
//        List<TjOrgPoliceDto> returnList=policeEquipmentMapper.TjOrgPoliceDetail(req,(req.getPageNo()-1)* req.getPageSize(),req.getPageSize());
//        Page<TjOrgPoliceDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
//        page.setTotal(size);
//        page.setRecords(returnList);
//        return PageResultFactory.createPageResult(page);
//    }

    @Override
    public List<TjOrgPoliceDto> TjOrgPoliceDetailList(TjOrgPoliceReq req) {
        List<TjOrgPoliceDto> returnList=policeEquipmentMapper.TjOrgPoliceDetail(req,null,null);
        return returnList;
    }


}
