package com.junmp.jyzb.mapper;

import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgCountDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgCountDto;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgCountReq;
import com.junmp.jyzb.entity.EquipmentCountSummary;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【vie_equipment_count_summary】的数据库操作Mapper
* @createDate 2023-12-14 14:41:35
* @Entity com.junmp.jyzb.entity.EquipmentCountSummary
*/
public interface EquipmentCountSummaryMapper extends BaseMapper<EquipmentCountSummary> {

    void addInfo(@Param("sql") String sql);

    TjOrgCountDto TjOrgCount(@Param("orgId") String orgId,
                             @Param("typeIdsList") List<String> typeIdsList,
                             @Param("sizeNameList") List<String> sizeNameList,
                             @Param("year")Integer year,
                             @Param("typeParentId")String typeParentId,
                             @Param("monthList") List<Integer> monthList);

    TjOrgCountDto TjOrgCountleve4(@Param("orgId") Long orgId,
                                  @Param("typeIdsList") List<String> typeIdsList,
                                  @Param("sizeNameList") List<String> sizeNameList,
                                  @Param("year") Integer year,
                                  @Param("typeParentId")String typeParentId,
                                  @Param("monthList") List<Integer> monthList,
                                  @Param("levelFlag")Integer levelFlag);

    List<TjOrgCountDto> TjOrgCountTotalNum(@Param("orgId") Long orgId,
                                           @Param("typeIdsList") List<String> typeIdsList,
                                           @Param("sizeNameList") List<String> sizeNameList,
                                           @Param("year") Integer year,
                                           @Param("typeParentId")String typeParentId,
                                           @Param("monthList") List<Integer> monthList,
                                           @Param("levelNum")Integer levelNum);


    FinalTjOrgCountDto TjOrgCountSum(@Param("orgId") Long orgId,
                                     @Param("sizeNameList") List<String> sizeNameList,
                                     @Param("typeIdsList") List<String> typeIdsList,
                                     @Param("year")Integer year);

    int TjOrgCountDetailSum(@Param("orgId")Long orgId,
                            @Param("year") Integer year,
                            @Param("typeIdsList") List<String> typeIdsList,
                            @Param("sizeNameList") List<String> sizeNameList);

    List<TjOrgCountDto> TjOrgCountDetail(@Param("orgId")Long orgId,
                                         @Param("year") Integer year,
                                         @Param("typeIdsList") List<String> typeIdsList,
                                         @Param("sizeNameList") List<String> sizeNameList,
                                         @Param("pageNo")Long pageNo, @Param("pageSize") Long pageSize);

    void deleteAll(@Param("orgId") Long orgId);

    List<TjOrgCountDto> TjOrgCountByType(@Param("req") TjOrgCountReq req);

    void setSizeName(@Param("sizeId") String id,@Param("sizeName") String name);

    void setTypeName(@Param("typeId") String id,@Param("typeName") String name);


}




