package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-Warehouse")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_warehouse")
public class Warehouse implements Serializable {
    @TableId(value = "id" , type = IdType.ASSIGN_UUID)
    private String id;

    @TableField("name")
    private String name;

    @TableField("location")
    private String location;

    @TableField("phone")
    private String phone;

    @TableField("video")
    private String video;

    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    @TableField("update_user")
    private String updateUser;

    @TableField("org_id_int")
    private Long orgId;

    @TableField("is_locked")
    private Integer isLocked;

    @TableField("sum")
    private Integer sum;

    @TableField("out_sum")
    private Integer outSum;

    @TableField("in_sum")
    private Integer inSum;

    @TableField("price_total")
    private BigDecimal priceTotal;

    @TableField("state")
    private Integer state;

    @TableField("order_id")
    private Long orderId;

    //湿度
    @TableField("humidity")
    private Double humidity;
    //温度
    @TableField("temperature")
    private Double temperature;



    private static final long serialVersionUID = 1L;
}