package com.junmp.jyzb.api.bean.req;

import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.jyzb.api.bean.query.InAndOutRecordReq.DetailJsonReq;
import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 记账时的子单据请求实体类
 */
@Data
public class UpdateOrderDetailReq implements Serializable {
    /**
     * 类型
     */
    private Long  id;
    /**
     * 单据类型，out出库，in入库
     */
    private String type;
    /**
     * 类型id
     */
    private String  typeId;
    /**
     * 类型名称
     */
    private String  typeName;
    /**
     * 号型
     */
    private String  sizeId;

    private String  sizeName;

    private String  supplierId;

    private String  supplierName;

    private Integer  planNum;
    private String price;

    private BigDecimal planTotalPrice;

    private BigDecimal actualTotalPrice;
    private String detailJson;

    private String warehouseId;

    private String warehouseName;

    private String orderId;

    //实际数量
    private Integer actualNum;

    private String orderType;

    private Date createTime;

    private Date updateTime;

    private String createUser;

    private String updateUser;

    //记账数量
    private Integer modifyQuantity;

    /**
     * 生产日期
     */
    private String productionDate;

    /**
     * 质保期
     */
    private Integer warrantyPeriod;

    /**
     * 维保期
     */
    private Integer maintenancePeriod;

    private String remark;
    private Long orgId;
    private List<DetailJsonReq> childJson;

    //Epc类型（0固定资产1库存物资非固定资产）
    private Integer property;
}
