package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.PeriodAndDateDto;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.EquipmentDto;
import com.junmp.jyzb.api.bean.query.*;

import com.junmp.jyzb.api.bean.req.BatchEditingInvsReq;
import com.junmp.jyzb.api.bean.req.EquipmentBindReq;
import com.junmp.jyzb.api.bean.req.RabbitMqOrderReq;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.entity.LogDetail;
import com.junmp.jyzb.entity.LogSummary;
import com.junmp.v2.db.api.page.PageResult;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public interface InventoryService extends IService<Inventory> {

    //根据装备id查询出装备的详细信息
    InventoryDto getInventoryDetail(InventoryReq msg);

    boolean UpdateWarehouseInsNum(WarehouseReq req);

    boolean UpdateCabinetInsNum(CabinetReq req);

    boolean InventoryBind(EquipmentBindReq req);

    List<InventoryDto> GetInvInfoByEpc(InventoryReq req);



    //查询箱门（cabinetBox下）所有装备简要信息列表（传递cabinetBoxId）
    List<EqsBriefDto> searchEqsByBoxId(CabinetBoxReq req);


    //通过货架id查询装备信息汇总
    List<InventorySummary> ShelfInventoryList(ShelfReq req);

    //根据货架id查询装备信息汇总 (page)
    PageResult<InventorySummary> ShelfInventoryPage(ShelfReq req);

    //通过货架id查询装备简要信息
    List<EqsBriefDto> ShelfInventoryDetail(InventoryReq req);
    PageResult<EqsBriefDto> ShelfInventoryPage(InventoryReq req);

    //通过区域id查询装备信息汇总(list)
    List<InventorySummary> AreaInventoryList(WarehouseAreaReq req);

    //通过区域id查询装备信息汇总(page)
    PageResult<InventorySummary> AreaInventoryPage(WarehouseAreaReq req);

    //通过装备id判断装备是否存在
    Inventory InventoryExist(String id);

    //通过单警柜箱门id获取箱门下的装备汇总信息(list)
    List<InventorySummary> EqsByCabinetBoxId(CabinetBoxReq req);

    //通过单警柜箱门id获取箱门下的装备汇总信息(page)
    PageResult<InventorySummary> EqsByCabinetBoxIdPage(CabinetBoxReq req);

    //通过组织机构id对该组织机构下的装备进行导出
    void ExportInventoryExcel(InventoryReq req);


    //通过条件查询装备数量报表
    List<EqsSumDto> GetListEquipment(InventoryReq req);

    //查询箱门（cabinetBox下）所有装备简要信息列表page（传递cabinetBoxId）
    PageResult<EqsBriefDto> searchEqsByBoxIdPage(CabinetBoxReq req);

    //根据条件查询仓库下的所有装备信息
    PageResult<InventoryDto> GetDetailByTerms(InventoryReq req);

    //批量信息修改
    boolean BatchEditingInvsInfo(BatchEditingInvsReq req);

    //判断epc是否存在
    List<String> checkEPCList(EpcCheckReq req);

    //根据条件查询满足条件的数据（用于快速移库修改装备仓库id）
    List<Inventory> selectEqsByItem(List<Object[]> searchCriteria);

    List<EquipmentDto> alignInventoryInfo(InventoryReq req);

    boolean EqsImport(InventoryReq req);

    PageResult<InventoryDto> EqsByState(InventoryReq req);

    List<PeriodAndDateDto> GetByPeriodAndDate(InventoryReq req);

}
