package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-Shelf")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_shelf")
public class Shelf implements Serializable {
    @TableId(value = "shelf_id", type = IdType.ASSIGN_UUID)
    private String shelfId;

    @TableField("area_id")
    private String areaId;

    @TableField("shelf_name")
    private String shelfName;

    @TableField("code")
    private String code;

    @TableField("type")
    private String type;

    @TableField("warehouse_id")
    private String warehouseId;

    @TableField("shelf_rows")
    private Integer shelfRows;

    @TableField("shelf_columns")
    private Integer shelfColumns;

    @TableField("shelf_ranges")
    private Integer shelfRanges;

    @TableField("url")
    private String url;

    @TableField("size_info")
    private String sizeInfo;

    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    @TableField("create_user")
    private String createUser;

    @TableField("update_user")
    private String updateUser;

    private static final long serialVersionUID = 1L;
}