package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


@TableName(value ="bussiness_inventory_detail")
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class BussinessDetail implements Serializable {
    /**
     * id
     */
    @TableId(value = "id")
    @Id
    private Long id;

    /**
     * 工作流id
     */
    @TableField(value = "inventory_id")
    private Long inventoryId;
    /**
     * 工作流id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 单据业务类型
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 单据编号
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 年度
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 月
     */
    @TableField(value = "stock_number")
    private Integer stockNumber;
    /**
     * 月
     */
    @TableField(value = "stock_price")
    private BigDecimal stockPrice;
    @TableField(value = "price")
    private BigDecimal price;
    /**
     * 月
     */
    @TableField(value = "fix_price")
    private BigDecimal fixPrice;
    /**
     * 申请时间
     */
    @TableField(value = "fix_number")
    private Integer fixNumber;

    /**
     * 仓库名称
     */
    @TableField(value = "num")
    private Integer num;
    /**
     * 仓库名称
     */
    @TableField(value = "state")
    private String state;
    /**
     * 人工添加数量
     */
    @TableField(value = "account_num")
    private String accountNum;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;



    private static final long serialVersionUID = 1L;

}