package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.api.util.GenCodeUtil;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.mapper.ProductMapper;
import com.junmp.jyzb.service.ProductService;
import com.junmp.jyzb.service.ProductSkuService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/30 13:46
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Service
@Slf4j
public class ProductServiceImpl extends ServiceImpl<ProductMapper, Product> implements ProductService {

    @Resource
    private ProductSkuService productSkuService;

    @Override
    public boolean addProduct(ProductReq req) {
        Product product = new Product();
        BeanPlusUtil.copyProperties(req, product);
        Integer maxSn = baseMapper.getMaxSn();
        //1-获取当前序号
        Integer sn = maxSn + 1;
        product.setSn(sn);
        //2-获取当前编码
        String code = GenCodeUtil.genProductCode(sn);
        product.setProductCode(code);
        return this.save(product);
    }

    @Override
    public boolean editProduct(ProductReq req) {
        Product product = this.queryProduct(req);
        BeanPlusUtil.copyProperties(req, product);
        return this.updateById(product);
    }

    @Override
    @Transactional
    public boolean del(ProductReq req) {
        Product product = queryProduct(req);
        this.removeById(req.getProductId());
        productSkuService.delByProductId(product.getProductId());
        return true;
    }

    @Override
    public List<Product> findList(ProductReq req) {
        LambdaQueryWrapper<Product> wrapper = createWrapper(req);
        return this.list(wrapper);
    }

    @Override
    public PageResult<Product> findPage(ProductReq req) {
        LambdaQueryWrapper<Product> wrapper = createWrapper(req);

        Page<Product> page = this.page(PageFactory.getDefaultPage(), wrapper);
        return PageResultFactory.createPageResult(page);
    }


    private Product queryProduct(ProductReq req) {
        Product app = this.getById(req.getProductId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(ProductExceptionEnum.PRODUCT_NOT_EXIST);
        }
        return app;
    }


    private LambdaQueryWrapper<Product> createWrapper(ProductReq req) {
        LambdaQueryWrapper<Product> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getProductCode()), Product::getProductCode, req.getProductCode());
        //根据企业名称模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()), Product::getName, req.getName());
        wrapper.orderByDesc(Product::getCreateTime);
        return wrapper;
    }
}
