package com.junmp.jyzb.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.domain.EquipmentSize;
import com.junmp.jyzb.domain.EquipmentType;
import com.junmp.jyzb.mapper.EquipmentTypeMapper;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.EquipmentSizeMapper;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class EquipmentSizeServiceImpl extends ServiceImpl<EquipmentSizeMapper, EquipmentSize> implements EquipmentSizeService {

    @Resource
    private EquipmentSizeMapper equipmentSizeMapper;

    @Resource
    private EquipmentTypeMapper equipmentTypeMapper;

    private static final String REDIS_SIZE = "Size_";

    @Override
    public ResponseResult addSize(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("typeId"), "typeId不能为空");
            checkNotBlank(msg.get("code"), "code不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            //checkNotBlank((String) msg.get("note"), "note不能为空");
            //Objects.requireNonNull(msg.get("price"), "price不能为空");
            Objects.requireNonNull(msg.get("epcType"), "epcType不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //TODO 查询是否有重复的code
//        List<String> sizeCodeFlag = equipmentSizeMapper.getSizeByCode((String) msg.get("code"));
//        if (!sizeCodeFlag.isEmpty()){
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"装备号型码已存在");
//        }

        //todo typeId只能是最下级的
//        List<String> resultId = equipmentTypeMapper.getLowestTypeId();
//        if (!resultId.contains(msg.get("typeId"))){
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"typeId只能是最下一级");
//        }

        EquipmentSize size =new EquipmentSize();
        //生成一个uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        size.setId(uuid);
        size.setCreateTime(currentDate);
        size.setUpdateTime(currentDate);

        size.setTypeId((String) msg.get("typeId"));
        size.setCode((String) msg.get("code"));
        size.setName((String) msg.get("name"));
        size.setNote((String) msg.get("note"));
        size.setPrice((Double) msg.get("price"));
        size.setEpcType((Integer) msg.get("epcType"));

        equipmentSizeMapper.addSize(size);


        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,uuid);
    }

    @Override
    public ResponseResult getOneSize(Map<String,Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        String sizeId = msg.get("id").toString();
        Map<String, Object> oneSize = equipmentSizeMapper.getOneSize(sizeId);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,oneSize);
    }

    @Override
    public ResponseResult deleteSize(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("sizeList"), "sizeList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        List<Object> sizeList = (List<Object>) msg.get("sizeList");
        for (Object sizeId:sizeList){
            equipmentSizeMapper.deleteSize(sizeId.toString());
        }
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    @Override
    public ResponseResult updateSize(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            checkNotBlank(msg.get("typeId"), "typeId不能为空");
            checkNotBlank(msg.get("code"), "code不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            Objects.requireNonNull(msg.get("epcType"), "epcType不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //todo 判断code是否重复
//        //查询是否有重复的code
//        List<String> sizeCodeFlag = equipmentSizeMapper.getSizeByCode((String) msg.get("code"));
//        //判断code是否有变动
//        String oldCode = equipmentSizeMapper.getCodeById(msg.get("id").toString());
//        if ()
//        if (!sizeCodeFlag.isEmpty()){
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"装备号型码已存在");
//        }

        EquipmentSize size =new EquipmentSize();
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        //police.setId(uuid);
        size.setId((String) msg.get("id"));
        size.setTypeId((String) msg.get("typeId"));
        size.setCode((String) msg.get("code"));
        size.setName((String) msg.get("name"));
        size.setNote((String) msg.get("note"));
        size.setUpdateTime(currentDate);
        size.setPrice((Double) msg.get("price"));
        //size.setState((Integer) msg.get("state"));
        size.setEpcType((Integer) msg.get("epcType"));
        equipmentSizeMapper.updateSize(size);

        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    @Override
    public List<String> getAllSizeId(Map<String, Object> typeId) {

        List<String> msg = equipmentSizeMapper.getAllSizeId(typeId.get("typeId").toString());
        return msg;
    }

    @Override
    public ResponseResult changeSizeState(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            checkNotBlank(msg.get("state"), "state不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        EquipmentSize size =new EquipmentSize();
        size.setId(msg.get("id").toString());
        size.setState((Integer) msg.get("state"));
        equipmentSizeMapper.changeSizeState(size);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult getAllSize(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("typeId"), "typeId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        List<Map<String, Object>> allSize=new ArrayList<>();
        List<String> allSizeId =getAllSizeId(msg);
        for (String sizeId :allSizeId){
            Map<String, Object> sizeMsg = equipmentSizeMapper.getOneSize(sizeId);
            allSize.add(sizeMsg);
        }
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,allSize);
    }

    @Override
    public ResponseResult getSizeDevelop() {
        List<Map<String,Object>> returnMsg = equipmentSizeMapper.getSizeDevelop();
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,returnMsg);
    }
}
